/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.WeightedSnapshot;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ExponentiallyDecayingReservoir
implements Reservoir {
    private static final int DEFAULT_SIZE = 1028;
    private static final double DEFAULT_ALPHA = 0.015;
    private static final long RESCALE_THRESHOLD = TimeUnit.HOURS.toNanos(1L);
    private final ConcurrentSkipListMap<Double, WeightedSnapshot.WeightedSample> values;
    private final ReentrantReadWriteLock lock;
    private final double alpha;
    private final int sizes;
    private final AtomicLong count;
    private volatile long startTime;
    private final AtomicLong nextScaleTime;
    private final Clock clock;
    private AtomicInteger preUpdate = new AtomicInteger(0);
    private AtomicBoolean isupdating = new AtomicBoolean(false);
    private AtomicInteger readCount = new AtomicInteger(0);

    public ExponentiallyDecayingReservoir() {
        this(1028, 0.015);
    }

    public ExponentiallyDecayingReservoir(int sizes, double alpha) {
        this(sizes, alpha, Clock.defaultClock());
    }

    public ExponentiallyDecayingReservoir(int sizes, double alpha, Clock clock) {
        this.values = new ConcurrentSkipListMap();
        this.lock = new ReentrantReadWriteLock();
        this.alpha = alpha;
        this.sizes = sizes;
        this.clock = clock;
        this.count = new AtomicLong(0L);
        this.startTime = this.currentTimeInSeconds();
        this.nextScaleTime = new AtomicLong(clock.getTick() + RESCALE_THRESHOLD);
    }

    public int size() {
        return (int)Math.min((long)this.sizes, this.count.get());
    }

    public void update(long value) {
        this.update(value, this.currentTimeInSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value, long timestamp) {
        this.rescaleIfNeeded();
        this.lockForRegularUsage();
        try {
            double itemWeight = this.weight(timestamp - this.startTime);
            WeightedSnapshot.WeightedSample sample = new WeightedSnapshot.WeightedSample(value, itemWeight);
            double priority = itemWeight / ThreadLocalRandom.current().nextDouble();
            long newCount = this.count.incrementAndGet();
            if (newCount <= (long)this.sizes) {
                this.values.put(priority, sample);
            } else {
                this.remove(priority, sample);
            }
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private void remove(double priority, WeightedSnapshot.WeightedSample sample) {
        Double first = this.values.firstKey();
        if (first < priority && this.values.putIfAbsent(priority, sample) == null) {
            while (this.values.remove(first) == null) {
                first = this.values.firstKey();
            }
        }
    }

    private void rescaleIfNeeded() {
        long next;
        long now = this.clock.getTick();
        if (now >= (next = this.nextScaleTime.get())) {
            this.rescale(now, next);
        }
    }

    public Snapshot getSnapshot() {
        this.lockForRegularUsage();
        try {
            WeightedSnapshot weightedSnapshot = new WeightedSnapshot(this.values.values());
            return weightedSnapshot;
        }
        finally {
            this.unlockForRegularUsage();
        }
    }

    private long currentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
    }

    private double weight(long t) {
        return Math.exp(this.alpha * (double)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescale(long now, long next) {
        if (this.nextScaleTime.compareAndSet(next, now + RESCALE_THRESHOLD)) {
            this.lockForRescale();
            try {
                long oldStartTime = this.startTime;
                this.startTime = this.currentTimeInSeconds();
                double scalingFactor = Math.exp(-this.alpha * (double)(this.startTime - oldStartTime));
                ArrayList keys = new ArrayList(this.values.keySet());
                for (Double key : keys) {
                    WeightedSnapshot.WeightedSample sample = this.values.remove(key);
                    if (sample == null) continue;
                    WeightedSnapshot.WeightedSample newSample = new WeightedSnapshot.WeightedSample(sample.value, sample.weight * scalingFactor);
                    this.values.put(key * scalingFactor, newSample);
                }
                this.count.set(this.values.size());
            }
            finally {
                this.unlockForRescale();
            }
        }
    }

    private void unlockForRescale() {
        if (this.isRWLock()) {
            this.lock.writeLock().unlock();
        } else {
            this.preUpdate.decrementAndGet();
            while (!this.isupdating.compareAndSet(true, false)) {
                LockSupport.parkNanos(10L);
            }
        }
    }

    private void lockForRescale() {
        if (this.isRWLock()) {
            this.lock.writeLock().lock();
        } else {
            this.preUpdate.incrementAndGet();
            Thread.yield();
            LockSupport.parkNanos(100L);
            while (this.readCount.get() > 0) {
                LockSupport.parkNanos(10L);
            }
            while (!this.isupdating.compareAndSet(false, true)) {
                LockSupport.parkNanos(10L);
            }
        }
    }

    private void lockForRegularUsage() {
        if (this.isRWLock()) {
            this.lock.readLock().lock();
        } else {
            while (this.isupdating.get() || this.preUpdate.get() > 0) {
                LockSupport.parkNanos(10L);
            }
            this.readCount.incrementAndGet();
        }
    }

    private void unlockForRegularUsage() {
        if (this.isRWLock()) {
            this.lock.readLock().unlock();
        } else {
            this.readCount.decrementAndGet();
        }
    }

    private boolean isRWLock() {
        return Boolean.getBoolean("metrics.lock.userw");
    }
}

