/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.audit;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.api.Probe;
import kd.bos.audit.AuditLogContext;
import kd.bos.audit.AuditLogger;
import kd.bos.audit.Auditable;
import kd.bos.audit.CostItem;
import kd.bos.audit.DefaultAuditLogContext;
import kd.bos.audit.LogbackAuditLogger;
import kd.bos.audit.OverCostException;
import kd.bos.bundle.Resources;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.EnableConfig;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Audit
implements Serializable {
    public static final String tracer_name = "audit";
    public static final String tracer_summary_name = "summary";
    public static final String tracer_detail_name = "detail";
    public static final String profile_audit_config_items_key = "audit.items";
    public static final String profile_audit_config_enable_key = "audit.enable";
    public static final String profile_audit_config_detail_key = "audit.detail";
    public static final String profile_audit_use_inner_config_key = "audit.use_inner_config";
    public static final String profile_audit_config_logcost_key = "audit.logCost";
    public static final String profile_audit_config_logmaxsize_key = "audit.logMaxSize";
    public static final String profile_audit_config_startup_delay_key = "audit.startup.delay";
    public static final String profile_audit_config_showmessage_instead_exception_key = "audit.showmessage.enable";
    public static final String profile_audit_config_log_enable_key = "audit.log.enable";
    private static final long serialVersionUID = -7112179670990094702L;
    private static final String inner_config_file = "/kd/bos/audit/audit.items";
    private static final Auditable empty = () -> {};
    private static int logMaxSize;
    private static int maxParamsDataSize;
    private static Map<String, String[]> namesMap;
    private static List<CostItem> ciTemplates;
    private static boolean enable;
    private static boolean logDetail;
    private static boolean useInnerConfig;
    private static boolean ifLogCost;
    private static boolean showMessageInsteadException;
    private static boolean overDelayed;
    private static long delayTS;
    private static long startupTS;
    private static Method getRequestContext;
    private static Method getAudit;
    private static ThreadLocal<Audit> paTH;
    private String traceId;
    private String serviceName;
    private Map<String, CostItem> costItemMap = new TreeMap<String, CostItem>();
    private transient AuditLogContext ctx;

    public Audit(String traceId) {
        this.traceId = traceId;
        this.addWithConfigured();
    }

    private static void loadTemplateFromConfig(boolean fireByUseInnerConfig) {
        String lines = null;
        if (fireByUseInnerConfig) {
            try {
                String[] stringArray = null;
                try (InputStream in = EnableConfig.class.getResourceAsStream(inner_config_file);){
                    int size;
                    InputStreamReader ir = new InputStreamReader(in);
                    char[] buf = new char[1024];
                    StringBuilder sb = new StringBuilder();
                    while ((size = ir.read(buf)) != -1) {
                        sb.append(buf, 0, size);
                    }
                    lines = sb.toString();
                    ir.close();
                }
                catch (Throwable object) {
                    stringArray = object;
                    throw object;
                }
            }
            catch (Exception e) {
                AuditLogger.log(e.getMessage());
            }
        } else {
            lines = System.getProperty(profile_audit_config_items_key);
        }
        if (lines != null) {
            ArrayList<CostItem> buf = new ArrayList<CostItem>();
            for (String line : StringUtils.split((String)lines, (boolean)true, (char[])new char[]{'\n', '\r', ';'})) {
                line = line.trim();
                try {
                    CostItem item = CostItem.of(line);
                    buf.add(item);
                }
                catch (Exception e) {
                    AuditLogger.log(e.getMessage());
                }
            }
            ciTemplates = buf;
        }
    }

    static Audit get() {
        Audit audit = paTH.get();
        try {
            if (audit == null && getRequestContext.invoke(null, new Object[0]) != null) {
                paTH.remove();
                audit = paTH.get();
            }
        }
        catch (Exception e) {
            AuditLogger.log(e.getMessage());
        }
        return audit;
    }

    static CostItem getCostItem(String name) {
        Audit audit = Audit.get();
        return audit == null ? null : audit.get(name);
    }

    public static Auditable audit(String names, Object ... params) {
        if (!Audit.isEnable()) {
            return empty;
        }
        String[] segs = namesMap.computeIfAbsent(names, s -> StringUtils.split((String)s, (boolean)true, (char[])new char[]{','}));
        Audit.scriptAudit(segs);
        if (segs.length == 1) {
            CostItem ci = Audit.getCostItem(names);
            if (ci == null) {
                return empty;
            }
            return ci.cost(params);
        }
        ArrayList<Auditable> ads = new ArrayList<Auditable>(segs.length);
        for (String seg : segs) {
            CostItem ci = Audit.getCostItem(seg);
            if (ci == null) continue;
            ads.add(ci.cost(params));
        }
        if (ads.isEmpty()) {
            return empty;
        }
        return () -> {
            for (Auditable ad : ads) {
                ad.close();
            }
        };
    }

    public static boolean auditDirect(String names, int times, long costs, long maxCost, Object ... params) {
        if (Audit.isEnable()) {
            String[] segs = namesMap.computeIfAbsent(names, s -> StringUtils.split((String)s, (boolean)true, (char[])new char[]{','}));
            Audit.scriptAudit(segs);
            if (segs.length == 1) {
                return Audit.isAudited(Audit.getCostItem(names), times, costs, maxCost, params);
            }
            return Audit.isAuditedSeg(segs, times, costs, maxCost, params);
        }
        return false;
    }

    private static boolean isAuditedSeg(String[] segs, int times, long costs, long maxCost, Object ... params) {
        boolean audited = false;
        for (String seg : segs) {
            CostItem ci = Audit.getCostItem(seg);
            if (ci == null) continue;
            if (Audit.isLogCost()) {
                Audit.logCost(ci);
            }
            ci.costDirect(times, costs, maxCost, params);
            if (audited) continue;
            audited = true;
        }
        return audited;
    }

    private static boolean isAudited(CostItem ci, int times, long costs, long maxCost, Object ... params) {
        if (ci != null) {
            if (Audit.isLogCost()) {
                Audit.logCost(ci);
            }
            ci.costDirect(times, costs, maxCost, params);
            return true;
        }
        return false;
    }

    public static String getShowMessage() {
        if (Audit.isEnable() && Audit.isShowMessageInsteadException()) {
            return Audit.warnMessage("getShowMessage");
        }
        return null;
    }

    public static void finallyAudit() {
        if (Audit.isEnable()) {
            try {
                Audit.throwMessage();
            }
            finally {
                Audit.reset();
            }
        }
    }

    private static void throwMessage() {
        String msg;
        if (!Audit.isShowMessageInsteadException() && (msg = Audit.warnMessage("finallyAudit")) != null) {
            throw new OverCostException(msg);
        }
    }

    private static String warnMessage(String tracerName) {
        Audit pa = Audit.get();
        if (pa != null && !pa.costItemMap.isEmpty()) {
            ArrayList<String> msgs = new ArrayList<String>(pa.costItemMap.size());
            ArrayList<CostItem> cis = new ArrayList<CostItem>(msgs.size());
            AtomicBoolean throwException = new AtomicBoolean(false);
            Audit.logReport(pa, msgs, cis, throwException);
            if (!msgs.isEmpty()) {
                StringBuilder sb = new StringBuilder(1024);
                if (pa.serviceName != null) {
                    sb.append(pa.serviceName);
                }
                sb.append(Audit.getAudit_log_key()).append(msgs.size()).append(Resources.getString((String)"bos-apm", (String)"Audit_1", (Object[])new Object[]{""}));
                int n = msgs.size();
                for (int i = 0; i < n; ++i) {
                    sb.append('\n').append(i + 1).append('.').append((String)msgs.get(i));
                }
                Audit.toTrace(tracerName, cis, sb);
                if (throwException.get()) {
                    return new StringBuilder(26 + sb.length()).append("[traceId=").append(pa.getTraceId()).append(']').append((CharSequence)sb).toString();
                }
            }
        }
        return null;
    }

    private static void logReport(Audit pa, List<String> msgs, List<CostItem> cis, AtomicBoolean throwException) {
        for (Map.Entry<String, CostItem> entry : pa.costItemMap.entrySet()) {
            CostItem ci = entry.getValue();
            if (Audit.isLogCost()) {
                Audit.logCost(ci);
            }
            if (ci.getCostThreshold().isWarnningImmediately() && !Audit.isShowMessageInsteadException()) continue;
            ci.getWarnning().ifPresent(info -> {
                String msg = info.getMsg();
                msgs.add(msg);
                cis.add(ci);
                AuditLogger.report(ci, msg);
                for (String stackMsg : info.getTopStackMsgs()) {
                    AuditLogger.report(ci, stackMsg);
                }
                if (!throwException.get() && ci.getCostThreshold().isThrowException()) {
                    throwException.set(true);
                }
            });
        }
    }

    private static void toTrace(String tracerName, List<CostItem> cis, StringBuilder sb) {
        try (TraceSpan ts = Tracer.create(tracer_name, tracerName);){
            boolean auditLogEnable;
            if (Tracer.isTracing() && TraceConfig.isTypeEnable(tracer_name) && (TraceConfig.isTagEnable(tracer_name, tracer_summary_name) || TraceConfig.isTagEnable(tracer_name, tracer_detail_name))) {
                ts.addTag(tracer_summary_name, cis.toString());
                ts.addTag(tracer_detail_name, sb.toString());
            }
            if (sb.length() > logMaxSize) {
                sb.setLength(logMaxSize);
                sb.append("...");
            }
            if (auditLogEnable = Boolean.parseBoolean(System.getProperty(profile_audit_config_log_enable_key, "false"))) {
                LogbackAuditLogger.log(sb.toString());
            } else {
                AuditLogger.log(sb.toString());
            }
        }
    }

    static void logCost(CostItem ci) {
        if (null != ci && ci.hasCost()) {
            String msg = ci.toSimpleString();
            AuditLogger.report(ci, msg);
        }
    }

    public static boolean isEnable() {
        if (enable) {
            if (delayTS > 0L) {
                if (overDelayed) {
                    return true;
                }
                overDelayed = System.currentTimeMillis() - startupTS > delayTS;
                return overDelayed;
            }
            return true;
        }
        return false;
    }

    public static boolean isEnable(String auditNames) {
        if (Audit.isEnable()) {
            String[] segs;
            Audit audit = Audit.get();
            if (audit == null) {
                return false;
            }
            for (String seg : segs = namesMap.computeIfAbsent(auditNames, s -> StringUtils.split((String)s, (boolean)true, (char[])new char[]{','}))) {
                if (audit.get(seg) == null) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isShowMessageInsteadException() {
        return showMessageInsteadException;
    }

    static boolean isLogDetail() {
        return logDetail;
    }

    static boolean isLogCost() {
        return ifLogCost;
    }

    static void reset() {
        paTH.remove();
    }

    private void addWithConfigured() {
        if (ciTemplates != null && !ciTemplates.isEmpty()) {
            for (CostItem ci : ciTemplates) {
                this.add(ci.getName(), ci.copy());
            }
        }
    }

    private void add(String name, CostItem ci) {
        this.costItemMap.put(name.toLowerCase(), ci);
    }

    public CostItem get(String name) {
        return this.costItemMap.get(name.toLowerCase());
    }

    public Set<String> keys() {
        return this.costItemMap.keySet();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String toString() {
        return (this.serviceName == null ? "" : this.serviceName) + this.costItemMap;
    }

    public AuditLogContext getAuditLogContext() {
        if (this.ctx == null) {
            this.ctx = new DefaultAuditLogContext();
        }
        return this.ctx;
    }

    public static String getAudit_log_key() {
        return Resources.getString((String)"bos-apm", (String)"Audit_0", (Object[])new Object[0]);
    }

    public static int getLogMaxSize() {
        return logMaxSize;
    }

    public static void setLogMaxSize(int logMaxSize) {
        Audit.logMaxSize = logMaxSize;
    }

    public static int getMaxParamsDataSize() {
        return maxParamsDataSize;
    }

    public static void setMaxParamsDataSize(int maxParamsDataSize) {
        Audit.maxParamsDataSize = maxParamsDataSize;
    }

    private static void scriptAudit(String[] names) {
        if (names != null && names.length > 0) {
            for (String name : names) {
                String lowerCaseName;
                if (name == null || name.length() == 0 || !"redis".equals(lowerCaseName = name.toLowerCase(Locale.ENGLISH)) && !"redis_sessionless".equals(lowerCaseName) && !"redis_sessionable".equals(lowerCaseName)) continue;
                Probe.touch((String)"redis");
                break;
            }
        }
    }

    static {
        maxParamsDataSize = 0x500000;
        namesMap = new ConcurrentHashMap<String, String[]>();
        ciTemplates = new ArrayList<CostItem>(0);
        overDelayed = false;
        paTH = ThreadLocals.create(() -> {
            try {
                Object rc = getRequestContext.invoke(null, new Object[0]);
                return rc == null ? null : (Audit)getAudit.invoke(rc, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        startupTS = System.currentTimeMillis();
        enable = Boolean.getBoolean(profile_audit_config_enable_key);
        ConfigurationUtil.observeChange((String)profile_audit_config_enable_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enable = Boolean.getBoolean(Audit.profile_audit_config_enable_key);
            }
        });
        logDetail = ConfigurationUtil.getBoolean((String)profile_audit_config_detail_key, (Boolean)false);
        ConfigurationUtil.observeChange((String)profile_audit_config_detail_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                logDetail = Boolean.getBoolean(Audit.profile_audit_config_detail_key);
            }
        });
        useInnerConfig = Boolean.getBoolean(profile_audit_use_inner_config_key);
        ConfigurationUtil.observeChange((String)profile_audit_use_inner_config_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                useInnerConfig = Boolean.getBoolean(Audit.profile_audit_use_inner_config_key);
                if (useInnerConfig) {
                    Audit.loadTemplateFromConfig(true);
                }
            }
        });
        ifLogCost = Boolean.getBoolean(profile_audit_config_logcost_key);
        ConfigurationUtil.observeChange((String)profile_audit_config_logcost_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                ifLogCost = Boolean.getBoolean(Audit.profile_audit_config_logcost_key);
            }
        });
        showMessageInsteadException = Boolean.parseBoolean(System.getProperty(profile_audit_config_showmessage_instead_exception_key, "true"));
        ConfigurationUtil.observeChange((String)profile_audit_config_showmessage_instead_exception_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                showMessageInsteadException = Boolean.parseBoolean(System.getProperty(Audit.profile_audit_config_showmessage_instead_exception_key, "true"));
            }
        });
        logMaxSize = Integer.parseInt(System.getProperty(profile_audit_config_logmaxsize_key, "2097152"));
        ConfigurationUtil.observeChange((String)profile_audit_config_logmaxsize_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                logMaxSize = Integer.parseInt(System.getProperty(Audit.profile_audit_config_logmaxsize_key, "2097152"));
            }
        });
        delayTS = Long.parseLong(System.getProperty(profile_audit_config_startup_delay_key, "0"));
        ConfigurationUtil.observeChange((String)profile_audit_config_startup_delay_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                delayTS = Long.parseLong(System.getProperty(Audit.profile_audit_config_startup_delay_key, "0"));
            }
        });
        ConfigurationUtil.observeChange((String)profile_audit_config_items_key, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                if (!useInnerConfig) {
                    Audit.loadTemplateFromConfig(false);
                }
            }
        });
        Audit.loadTemplateFromConfig(useInnerConfig);
        try {
            Class<?> cls = Class.forName("kd.bos.context.RequestContext");
            getRequestContext = cls.getMethod("get", new Class[0]);
            getAudit = cls.getMethod("getAudit", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

