/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.audit;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.Resources;

class AuditDesc {
    private static final Map<String, String> costItemNameDescMap = new HashMap<String, String>();
    private static final String BOS_APM = "bos-apm";
    private static final String AUDIT_DESC_FIVE = "AuditDesc_5";

    AuditDesc() {
    }

    private static void initCostItemNameDescMap() {
        costItemNameDescMap.put("db_cost", Resources.getString((String)BOS_APM, (String)"AuditDesc_0", (Object[])new Object[0]));
        costItemNameDescMap.put("tx_duration", Resources.getString((String)BOS_APM, (String)"AuditDesc_1", (Object[])new Object[0]));
        costItemNameDescMap.put("tx_times", Resources.getString((String)BOS_APM, (String)"AuditDesc_2", (Object[])new Object[0]));
        costItemNameDescMap.put("connection_cost", Resources.getString((String)BOS_APM, (String)"AuditDesc_3", (Object[])new Object[0]));
        costItemNameDescMap.put("connection_holding", Resources.getString((String)BOS_APM, (String)"AuditDesc_4", (Object[])new Object[0]));
        costItemNameDescMap.put("redis", Resources.getString((String)BOS_APM, (String)AUDIT_DESC_FIVE, (Object[])new Object[0]));
        costItemNameDescMap.put("redis_sessionable", Resources.getString((String)BOS_APM, (String)AUDIT_DESC_FIVE, (Object[])new Object[0]));
        costItemNameDescMap.put("redis_sessionless", Resources.getString((String)BOS_APM, (String)AUDIT_DESC_FIVE, (Object[])new Object[0]));
        costItemNameDescMap.put("mservice_cost", Resources.getString((String)BOS_APM, (String)"AuditDesc_6", (Object[])new Object[0]));
        costItemNameDescMap.put("dubbo_cost", Resources.getString((String)BOS_APM, (String)"AuditDesc_7", (Object[])new Object[0]));
        costItemNameDescMap.put("sql", Resources.getString((String)BOS_APM, (String)"AuditDesc_8", (Object[])new Object[0]));
        costItemNameDescMap.put("sql_null_filter", Resources.getString((String)BOS_APM, (String)"AuditDesc_9", (Object[])new Object[0]));
        costItemNameDescMap.put("sql_pk_range_filter", Resources.getString((String)BOS_APM, (String)"AuditDesc_10", (Object[])new Object[0]));
        costItemNameDescMap.put("sql_express_property_filter", Resources.getString((String)BOS_APM, (String)"AuditDesc_11", (Object[])new Object[0]));
        costItemNameDescMap.put("dlock_cost", Resources.getString((String)BOS_APM, (String)"AuditDesc_12", (Object[])new Object[0]));
        costItemNameDescMap.put("id_cost", Resources.getString((String)BOS_APM, (String)"AuditDesc_13", (Object[])new Object[0]));
        costItemNameDescMap.put("function", Resources.getString((String)BOS_APM, (String)"AuditDesc_14", (Object[])new Object[0]));
        costItemNameDescMap.put("operation", Resources.getString((String)BOS_APM, (String)"AuditDesc_15", (Object[])new Object[0]));
        costItemNameDescMap.put("datasource", Resources.getString((String)BOS_APM, (String)"AuditDesc_16", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCostItemNameDesc(String costItemName) {
        String ret;
        if (costItemNameDescMap.isEmpty()) {
            Map<String, String> map = costItemNameDescMap;
            synchronized (map) {
                AuditDesc.initCostItemNameDescMap();
            }
        }
        if ((ret = costItemNameDescMap.get(costItemName)) == null) {
            if (costItemName.startsWith("function_")) {
                ret = Resources.getString((String)BOS_APM, (String)"AuditDesc_17", (Object[])new Object[0]) + costItemName.substring(9);
            } else if (costItemName.startsWith("operation_")) {
                ret = Resources.getString((String)BOS_APM, (String)"AuditDesc_18", (Object[])new Object[0]) + costItemName.substring(10);
            } else {
                return costItemName;
            }
        }
        return "[" + costItemName + "]" + ret;
    }
}

