/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.audit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.audit.Audit;
import kd.bos.audit.AuditDesc;
import kd.bos.audit.AuditLogger;
import kd.bos.audit.Auditable;
import kd.bos.audit.CostThreshold;
import kd.bos.audit.OverCostException;
import kd.bos.audit.WarnningInfo;
import kd.bos.bundle.Resources;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;

public class CostItem
implements Serializable {
    private static final long serialVersionUID = 7537492392512314687L;
    private static Pattern p = Pattern.compile("(.+)\\=(-?\\d+)\\,(-?\\d+)\\,(-?\\d+),(.+),(.+)");
    private String name;
    private int times = 0;
    private long costs = 0L;
    private long maxCost = 0L;
    private int outTimes = Integer.parseInt(System.getProperty("audit.out.times", "1"));
    private int outTop = Integer.parseInt(System.getProperty("audit.out.topsize", "10"));
    private int simpleTop = Integer.parseInt(System.getProperty("audit.out.simpletopsize", "5"));
    private TreeMap<String, Integer> countMap = new TreeMap();
    private TreeMap<String, String> outParamsMap = new TreeMap();
    private TreeMap<String, String> outStackMsgMap = new TreeMap();
    private CostThreshold ct;
    private AtomicBoolean locking = new AtomicBoolean();
    private boolean warnedImmediately = false;
    private static final String BOS_APM = "bos-apm";
    private static final String AUDIT_IGNORE_METHODS = "audit.ignore.methods";

    public CostItem(String name, CostThreshold ct) {
        this.name = name;
        this.ct = ct;
    }

    public static CostItem of(String s) {
        Matcher m = p.matcher(s);
        if (m.matches()) {
            String name = m.group(1);
            int times = Integer.parseInt(m.group(2).trim());
            long costs = Long.parseLong(m.group(3).trim());
            long maxCost = Long.parseLong(m.group(4).trim());
            boolean warnningImmediately = Boolean.parseBoolean(m.group(5).trim());
            boolean throwException = Boolean.parseBoolean(m.group(6).trim());
            return new CostItem(name, new CostThreshold(times, costs, maxCost, warnningImmediately, throwException));
        }
        throw new IllegalArgumentException(Resources.getString((String)BOS_APM, (String)"CostItem_0", (Object[])new Object[0]) + s);
    }

    Auditable cost(Object ... params) {
        long ts = System.currentTimeMillis();
        return () -> this.cost(System.currentTimeMillis() - ts, params);
    }

    private void cost(long ts, Object ... params) {
        ++this.times;
        this.costs += ts;
        if (this.maxCost < ts) {
            this.maxCost = ts;
        }
        this.checkCost(true, params);
    }

    void costDirect(int times, long costs, long maxCost, Object ... params) {
        this.times = times;
        this.costs = costs;
        this.maxCost = maxCost;
        this.checkCost(false, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCost(boolean logCostSelf, Object ... params) {
        if (Audit.isLogDetail()) {
            this.requireLock();
            try {
                Object[] stes = Thread.currentThread().getStackTrace();
                if (this.isContainIgnoreMethod((StackTraceElement[])stes)) {
                    return;
                }
                String hash = String.valueOf(Arrays.hashCode(stes));
                Integer count = this.countMap.get(hash);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                this.countMap.put(hash, count);
                if (count >= this.outTimes) {
                    int len = stes.length;
                    int simpleCount = 0;
                    StringBuilder stackMsg = new StringBuilder();
                    StringBuilder param = new StringBuilder();
                    for (int startIndex = 5; startIndex < len; ++startIndex) {
                        String stack = ((StackTraceElement)stes[startIndex]).toString();
                        int p = stack.lastIndexOf(40);
                        if (p != -1) {
                            stack = stack.substring(0, p) + ':' + ((StackTraceElement)stes[startIndex]).getLineNumber();
                        }
                        if (simpleCount < this.simpleTop) {
                            param.append('\t').append(stack).append('\n');
                            ++simpleCount;
                        }
                        stackMsg.append('\t').append(stack).append('\n');
                    }
                    param.append("\n\t").append(this.parameter2String(params).replace('\n', ' ').replace('\r', ' '));
                    this.outParamsMap.put(hash, param.toString());
                    this.outStackMsgMap.put(hash, stackMsg.toString());
                }
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
            finally {
                this.releaseLock();
            }
        }
    }

    private boolean isContainIgnoreMethod(StackTraceElement[] stes) {
        String auditIgnoreMethods = System.getProperty(AUDIT_IGNORE_METHODS);
        if (StringUtils.isNotEmpty((String)auditIgnoreMethods)) {
            String[] ignoreMethodArr;
            for (String ignoreMethod : ignoreMethodArr = auditIgnoreMethods.split(",")) {
                String tempStr = ignoreMethod.trim();
                for (StackTraceElement ste : stes) {
                    if (!tempStr.equals(ste.getClassName() + "." + ste.getMethodName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void throwTrace(String msg, boolean logCostSelf) {
        boolean costItemReported = AuditLogger.report(this, msg);
        if (this.ct.isThrowException()) {
            if (!costItemReported && logCostSelf && Audit.isLogCost()) {
                Audit.logCost(this);
            }
            try {
                throw new OverCostException("[traceId=" + Audit.get().getTraceId() + "]" + msg);
            }
            catch (Throwable throwable) {
                Audit.reset();
                throw throwable;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getTimes() {
        return this.times;
    }

    public long getCosts() {
        return this.costs;
    }

    public long getMaxCost() {
        return this.maxCost;
    }

    public CostThreshold getCostThreshold() {
        return this.ct;
    }

    public String toString() {
        return "{name: " + this.name + ", times: " + this.times + ", costs: " + this.costs + ", maxCost: " + this.maxCost + "}";
    }

    public String toSimpleString() {
        int N = 25;
        StringBuilder sb = new StringBuilder(25);
        int n = 25 - this.name.length();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        sb.append(this.name);
        sb.append(" times=").append(this.times).append(", costs=").append(this.costs).append(", maxCost=").append(this.maxCost).append(", params=").append(this.getDetail());
        return sb.toString();
    }

    public String getDetail() {
        if (this.outParamsMap.isEmpty()) {
            return "";
        }
        int LEN = 80;
        this.requireLock();
        ArrayList<String> paramList = new ArrayList<String>(this.outParamsMap.size());
        for (Map.Entry<String, String> entry : this.outParamsMap.entrySet()) {
            paramList.add(entry.getValue());
        }
        String ps = ((Object)paramList).toString();
        this.releaseLock();
        if (ps.length() > 83) {
            ps = ps.substring(0, 80) + "...";
        }
        return ps;
    }

    String parameter2String(Object ... params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder(64);
            int n = params.length;
            for (int j = 0; j < n; ++j) {
                Object p = params[j];
                if (j > 0) {
                    sb.append(',');
                }
                if (p != null && p.getClass().isArray()) {
                    this.paramAppend(p, sb);
                    continue;
                }
                sb.append(p);
            }
            if (sb.length() > Audit.getLogMaxSize()) {
                sb.setLength(Audit.getLogMaxSize());
                sb.append("...");
            }
            return sb.toString();
        }
        return "";
    }

    private void paramAppend(Object p, StringBuilder sb) {
        int m = Array.getLength(p);
        for (int k = 0; k < m; ++k) {
            Object q;
            if (k > 0) {
                sb.append(',');
            }
            if ((q = Array.get(p, k)) != null && q.getClass().isArray()) {
                sb.append(Collections.singletonList(q));
                continue;
            }
            sb.append(q);
        }
    }

    Optional<WarnningInfo> getWarnning() {
        List<String> warnnings = this.fireWarnning();
        if (!warnnings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(AuditDesc.getCostItemNameDesc(this.name)).append(',');
            for (String s : warnnings) {
                sb.append(s).append(',');
            }
            WarnningInfo warnningInfo = new WarnningInfo(sb.toString());
            if (!this.countMap.isEmpty()) {
                sb.append(Resources.getString((String)BOS_APM, (String)"CostItem_2", (Object[])new Object[0]));
                sb.append(Resources.getString((String)BOS_APM, (String)"CostItem_10", (Object[])new Object[0]).replace("{{outTimes}}", String.valueOf(this.outTimes)).replace("{{outTop}}", String.valueOf(this.outTop)));
                warnningInfo = this.getWarnnigInfo(sb);
            }
            if (this.outParamsMap.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(warnningInfo);
        }
        return Optional.empty();
    }

    private WarnningInfo getWarnnigInfo(StringBuilder sb) {
        WarnningInfo warnInfo = new WarnningInfo("");
        if (!this.countMap.isEmpty()) {
            int top = this.countMap.size() > this.outTop ? this.outTop : this.countMap.size();
            for (int i = 0; i < top; ++i) {
                int maxCount = 0;
                String maxKey = null;
                for (Map.Entry<String, Integer> p : this.countMap.entrySet()) {
                    int count = p.getValue();
                    if (count <= maxCount) continue;
                    maxCount = count;
                    maxKey = p.getKey();
                }
                if (maxCount >= this.outTimes) {
                    sb.append("\n\t");
                    StringBuilder tempSb = new StringBuilder();
                    tempSb.append(Resources.getString((String)BOS_APM, (String)"CostItem_3", (Object[])new Object[0])).append(maxCount).append(Resources.getString((String)BOS_APM, (String)"CostItem_4", (Object[])new Object[0]));
                    String param = this.outParamsMap.get(maxKey);
                    if (param != null) {
                        tempSb.append(param);
                    }
                    sb.append((CharSequence)tempSb);
                    String stackMsg = this.outStackMsgMap.get(maxKey);
                    if (stackMsg != null) {
                        tempSb.insert(0, "\n");
                        tempSb.append("\n").append(stackMsg);
                        warnInfo.addTopStackMsg(tempSb.toString());
                    }
                }
                this.countMap.remove(maxKey);
            }
        }
        warnInfo.setMsg(sb.toString());
        return warnInfo;
    }

    private List<String> fireWarnning() {
        ArrayList<String> ret = new ArrayList<String>(3);
        if (this.ct.withTimes() && this.times > this.ct.getTimes()) {
            ret.add(String.format(kd.bos.util.resource.Resources.getString((String)"\u8bbf\u95ee\u6b21\u6570\u8d85\u6807(%s)", (String)"CostItem_5", (String)BOS_APM, (Object[])new Object[0]), this.times + ">" + this.ct.getTimes()));
        }
        if (this.ct.withCosts() && this.costs > this.ct.getCosts()) {
            ret.add(String.format(kd.bos.util.resource.Resources.getString((String)"\u7d2f\u8ba1\u8017\u65f6\u8d85\u6807(%s)ms", (String)"CostItem_6", (String)BOS_APM, (Object[])new Object[0]), this.costs + ">" + this.ct.getCosts()));
        }
        if (this.ct.withMaxCost() && this.maxCost > this.ct.getMaxCost()) {
            ret.add(String.format(kd.bos.util.resource.Resources.getString((String)"\u5355\u6b21\u6700\u5927\u8017\u65f6\u8d85\u6807(%s)ms", (String)"CostItem_7", (String)BOS_APM, (Object[])new Object[0]), this.maxCost + ">" + this.ct.getMaxCost()));
        }
        return ret;
    }

    CostItem copy() {
        return new CostItem(this.name, this.ct);
    }

    boolean hasCost() {
        return this.times > 0 || this.costs > 0L || this.maxCost > 0L;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.requireLock();
        os.defaultWriteObject();
        os.writeUTF(this.name);
        os.writeInt(this.times);
        os.writeLong(this.costs);
        os.writeLong(this.maxCost);
        os.writeObject(this.countMap);
        os.writeObject(this.outParamsMap);
        os.writeObject(this.outStackMsgMap);
        os.writeObject(this.ct);
        this.releaseLock();
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.name = is.readUTF();
        this.times = is.readInt();
        this.costs = is.readLong();
        this.maxCost = is.readLong();
        this.countMap = (TreeMap)is.readObject();
        this.outParamsMap = (TreeMap)is.readObject();
        this.outStackMsgMap = (TreeMap)is.readObject();
        this.ct = (CostThreshold)is.readObject();
        this.locking = new AtomicBoolean();
    }

    private void requireLock() {
        if (this.locking.get()) {
            String message = Audit.getAudit_log_key() + Resources.getString((String)BOS_APM, (String)"CostItem_8", (Object[])new Object[0]) + String.format(kd.bos.util.resource.Resources.getString((String)"%s\uff0c\u8bf7\u5728\u65b0\u7ebf\u7a0b\u4e2d\u4fee\u6539\uff1aRequestContext.set(rc)-->RequestContext.copyAndSet(rc)", (String)"CostItem_9", (String)BOS_APM, (Object[])new Object[0]), Thread.currentThread().getName());
            AuditLogger.log(message);
            throw new RuntimeException(message);
        }
        this.locking.set(true);
    }

    private void releaseLock() {
        this.locking.set(false);
    }
}

