/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.audit.sql;

import kd.bos.audit.Audit;
import kd.bos.audit.sql.SqlAuditor;

public class ForbidNullFilter
implements SqlAuditor {
    public static final String audit_names = "sql,sql_null_filter";

    @Override
    public boolean audit(String sql) {
        if (ForbidNullFilter.withNullFilter(sql)) {
            return Audit.auditDirect(audit_names, 1, 0L, 0L, sql);
        }
        return false;
    }

    private static boolean withNullFilter(String sql) {
        String part = sql.toLowerCase();
        int p1 = part.lastIndexOf(" null");
        if (p1 > 0) {
            if ((part = part.substring(0, p1).trim()).endsWith(" is")) {
                return true;
            }
            if (part.endsWith(" not") && (part = part.substring(0, part.length() - 4).trim()).endsWith(" is")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean enable() {
        return Audit.isEnable(audit_names);
    }
}

