/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.StorageReporter;
import kd.bos.govern.StorageReporterRegister;
import kd.bos.govern.StorageType;
import kd.bos.util.StringUtils;

public class StorageReporterFactory {
    private static Map<String, StorageReporter> reporterMap = new ConcurrentHashMap<String, StorageReporter>(8);

    private static StorageReporter getInstance(String dataSource, StorageType type) {
        String dataSourceKey = type != null ? dataSource + type.value() : dataSource;
        return reporterMap.computeIfAbsent(dataSourceKey, key -> {
            StorageType storageType = StorageType.getStorageType(StorageReporterFactory.getType(dataSource, type));
            if (storageType == StorageType.MC) {
                return StorageReporterRegister.getMcImpl();
            }
            if (storageType == StorageType.ELASTICSEARCH) {
                return StorageReporterRegister.getEsImpl();
            }
            if (storageType == StorageType.DB) {
                return StorageReporterRegister.getDbImpl();
            }
            if (storageType == StorageType.KAFKA) {
                return StorageReporterRegister.getKafkaImpl();
            }
            return StorageReporterRegister.getEsImpl();
        });
    }

    public static StorageReporter getStorageReporter() {
        return StorageReporterFactory.getInstance(null, null);
    }

    public static StorageReporter getStorageReporter(GovernDataType dataType) {
        return StorageReporterFactory.getInstance(dataType.value(), null);
    }

    public static StorageReporter getStorageReporter(GovernDataType dataType, StorageType type) {
        return StorageReporterFactory.getInstance(dataType.value(), type);
    }

    private static String getType(String dataSource, StorageType type) {
        if (dataSource == null && type == null) {
            return System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value());
        }
        String paramType = "apm.gov.invoke.report.storage.type." + dataSource;
        String storageType = System.getProperty(paramType);
        if (StringUtils.isNotEmpty((String)storageType)) {
            return storageType;
        }
        if (type != null) {
            return type.value();
        }
        return System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value());
    }
}

