/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern.eventdata;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.eventdata.EventType;
import kd.bos.instance.Instance;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.NetAddressUtils;

public class EventData
extends GovernPoJo {
    private static final boolean logAnonymityEnable = Boolean.getBoolean("log.anonymity.enable");
    private String firstEventType;
    private String secondEventType;
    private String clusterName = Instance.getClusterName();
    private String appName = Instance.getAppName();
    private String instanceId = Instance.getInstanceId();
    private String ip = NetAddressUtils.getLocalIpAddress();
    private String appId;
    private String traceId;
    private String tenantId;
    private String accountId;
    private String userId;
    private String userName;
    private String message;
    private Long timestamp;
    private Throwable throwable;

    private EventData() {
    }

    public EventData(EventType eventType, String message) {
        this(eventType, message, null);
    }

    public EventData(EventType eventType, String message, Throwable t) {
        RequestTimeoutContext timeoutContext;
        this.firstEventType = eventType.getParentName();
        this.secondEventType = eventType.getName();
        this.message = message == null ? "" : message;
        this.timestamp = System.currentTimeMillis();
        Object rcInfo = ThreadTruck.get((Object)"rcinfo");
        if (rcInfo instanceof Map) {
            Map rcInfoMap = (Map)rcInfo;
            this.traceId = (String)rcInfoMap.get("traceId");
            this.tenantId = (String)rcInfoMap.get("tenantId");
            this.accountId = (String)rcInfoMap.get("accountId");
            this.userId = (String)rcInfoMap.get("userId");
            if (!logAnonymityEnable) {
                this.userName = (String)rcInfoMap.get("userName");
            }
        }
        if ((timeoutContext = RequestTimeoutContext.get()) != null) {
            this.appId = timeoutContext.getAppId();
        }
        this.throwable = t;
    }

    public String getFirstEventType() {
        return this.firstEventType;
    }

    public void setFirstEventType(String firstEventType) {
        this.firstEventType = firstEventType;
    }

    public String getSecondEventType() {
        return this.secondEventType;
    }

    public void setSecondEventType(String secondEventType) {
        this.secondEventType = secondEventType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public EventData setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public EventData setTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public EventData setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public EventData setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public EventData setMessage(String message) {
        this.message = message;
        return this;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    /*
     * Exception decompiling
     */
    private String convertStackTraceToString(Throwable throwable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, Object> data2map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("firstEventType", this.firstEventType);
        map.put("secondEventType", this.secondEventType);
        map.put("clusterName", this.clusterName);
        map.put("appName", this.appName);
        map.put("appId", this.appId);
        map.put("instanceId", this.instanceId);
        map.put("ip", this.ip);
        map.put("traceId", this.traceId);
        map.put("tenantId", this.tenantId);
        map.put("accountId", this.accountId);
        map.put("userId", this.userId);
        map.put("userName", this.userName);
        if (this.throwable != null) {
            this.message = this.message + "\r\n" + this.convertStackTraceToString(this.throwable);
        }
        if (this.message.length() > 256) {
            map.put("message", this.message.substring(0, 256));
            map.put("message2", this.message.substring(256));
        } else {
            map.put("message", this.message);
        }
        map.put("timestamp", this.timestamp);
        return map;
    }
}

