/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern.eventdata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.types.CircuitBreakerEvent;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.govern.eventdata.types.MultiTenantResourceEvent;
import kd.bos.govern.eventdata.types.TerminationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTypeManager {
    private static final Logger logger = LoggerFactory.getLogger(EventTypeManager.class);
    private static final List<EventType> firstEventType = new ArrayList<EventType>(4);

    public static void init() {
    }

    public static List<EventType> getAllFirstEventType() {
        return firstEventType;
    }

    static {
        firstEventType.add(LimitEvent.getInstance());
        firstEventType.add(TerminationEvent.getInstance());
        firstEventType.add(CircuitBreakerEvent.getInstance());
        firstEventType.add(MultiTenantResourceEvent.getInstance());
        ServiceLoader<EventType> serviceLoader = ServiceLoader.load(EventType.class);
        Iterator<EventType> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                EventType eventType = itr.next();
                if (!(eventType instanceof EventType)) continue;
                List<EventType> subTypes = eventType.getSubTypes();
                if (subTypes != null && subTypes.size() > 0) {
                    firstEventType.add(eventType);
                    logger.info("EventTypeManager serviceLoader successfully loaded class: " + eventType.getClass().getName());
                    continue;
                }
                logger.warn("The eventType class {} has no subtypes,loading failed", (Object)eventType.getClass().getName());
            }
            catch (Error | Exception e) {
                logger.error("Load eventType class failed,errorMessage:" + e.getMessage(), e);
            }
        }
    }
}

