/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.govern.eventdata.reporter;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporterFactory;
import kd.bos.govern.eventdata.EventData;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;

public class EventDataReporter {
    private static final BlockingQueue<EventData> eventDataQueue = new LinkedBlockingQueue<EventData>(10000);
    private static String metricName = "kd.metrics.gov.event.limit.counts";
    private static Counter limitEventCounter = MetricSystem.counter(metricName);

    public static void report(EventType eventType, String message) {
        EventDataReporter.report(new EventData(eventType, message));
    }

    public static void report(EventType eventType, String message, Throwable t) {
        EventDataReporter.report(new EventData(eventType, message, t));
    }

    public static void report(EventData eventData) {
        eventDataQueue.offer(eventData);
        if (LimitEvent.getInstance().getName().equals(eventData.getFirstEventType())) {
            limitEventCounter.inc();
        }
    }

    static {
        Thread reportThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        int size;
                        if ((size = eventDataQueue.size()) == 0) {
                            EventData eventData = eventDataQueue.take();
                            if (eventData != null) {
                                StorageReporterFactory.getStorageReporter(GovernDataType.EVENT_DATA).reporter(eventData);
                            }
                        } else {
                            ArrayList<GovernPoJo> governPoJos = new ArrayList<GovernPoJo>(size);
                            for (int i = 0; i < size; ++i) {
                                governPoJos.add((GovernPoJo)eventDataQueue.poll());
                                if (governPoJos.size() > GovernConfigs.getReportBatchSize()) break;
                            }
                            StorageReporterFactory.getStorageReporter(GovernDataType.EVENT_DATA).reporter(governPoJos);
                            governPoJos.clear();
                        }
                        TimeUnit.MILLISECONDS.sleep(1000L);
                    }
                }
                catch (Exception e) {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }, "EventData-report");
        reportThread.setDaemon(true);
        reportThread.start();
    }
}

