/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kd.bos.metric.Counter;
import kd.bos.metric.Gauge;
import kd.bos.metric.Gauger;
import kd.bos.metric.Histogram;
import kd.bos.metric.Meter;
import kd.bos.metric.Timer;
import kd.bos.metric.core.MetricReporter;
import kd.bos.metric.core.TimerWrapper;
import kd.bos.metric.reporter.OperatingSystemMetricSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSystem {
    public static final String domain = "kd.metrics";
    private static Logger logger = LoggerFactory.getLogger(MetricSystem.class);
    private static Map<String, MetricRegistry> metricRegistryMap = new ConcurrentHashMap<String, MetricRegistry>();
    private static Map<String, Object> metricMap = new ConcurrentHashMap<String, Object>();
    private static MetricRegistry metricRegistry;

    public static MetricRegistry registry(String domain) {
        return metricRegistryMap.computeIfAbsent(domain, name -> {
            MetricRegistry registry = new MetricRegistry();
            MetricReporter.register(name, registry);
            return registry;
        });
    }

    public static MetricRegistry getMetricRegistry() {
        return metricRegistry;
    }

    public static boolean remove(String name) {
        Object o = metricMap.remove(name);
        if (o != null) {
            return metricRegistry.remove(name);
        }
        return false;
    }

    @Deprecated
    public static <T> void registerGauge(String name, Gauge<T> gauge) {
        MetricSystem.gauge(name, () -> gauge);
    }

    public static <T> void gauge(String name, final Supplier<Gauge<T>> gaugeSupplier) {
        if (metricMap.containsKey(name)) {
            throw new IllegalArgumentException(name + " is already used for a different instance of metric");
        }
        metricMap.put(name, metricRegistry.register(name, (Metric)new com.codahale.metrics.Gauge<T>(){

            public T getValue() {
                return ((Gauge)gaugeSupplier.get()).getValue();
            }
        }));
    }

    public static <T> Gauger<T> gauger(String name) {
        return (Gauger)metricMap.computeIfAbsent(name, key -> {
            final Gauger gauger = new Gauger();
            metricRegistry.gauge(name, () -> new com.codahale.metrics.Gauge<T>(){

                public T getValue() {
                    return gauger.getValue();
                }
            });
            return gauger;
        });
    }

    public static Counter counter(String name) {
        return (Counter)metricMap.computeIfAbsent(name, key -> new Counter(metricRegistry.counter(key)));
    }

    public static Meter meter(String name) {
        return (Meter)metricMap.computeIfAbsent(name, key -> new Meter(metricRegistry.meter(key)));
    }

    public static Timer timer(String name) {
        return (Timer)metricMap.computeIfAbsent(name, key -> {
            com.codahale.metrics.Timer timer = metricRegistry.timer(key);
            return new TimerWrapper(timer);
        });
    }

    public static Histogram histogram(String name) {
        return (Histogram)metricMap.computeIfAbsent(name, key -> new Histogram(metricRegistry.histogram(key)));
    }

    static {
        try {
            Class.forName("kd.bos.config.client.ConfigurationFactory");
        }
        catch (Exception e) {
            logger.warn("MetricSystem static error:", (Throwable)e);
        }
        metricRegistry = MetricSystem.registry(domain);
        metricRegistry.register("kd.metrics.jvm.gc", (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register("kd.metrics.jvm.memory", (Metric)new MemoryUsageGaugeSet());
        metricRegistry.register("kd.metrics.jvm.system", (Metric)new OperatingSystemMetricSet());
    }
}

