/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.instruments.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;

public class MetricAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String config_prefix_key = "metric.logback.prefix";
    private String prefix = "kd.metrics.logback.";
    private Meter all;
    private Meter trace;
    private Meter debug;
    private Meter info;
    private Meter warn;
    private Meter error;

    private String name(String suffix) {
        return this.prefix + suffix;
    }

    public void start() {
        this.prefix = System.getProperty(config_prefix_key, this.prefix);
        this.all = MetricSystem.meter(this.name("all"));
        this.trace = MetricSystem.meter(this.name("trace"));
        this.debug = MetricSystem.meter(this.name("debug"));
        this.info = MetricSystem.meter(this.name("info"));
        this.warn = MetricSystem.meter(this.name("warn"));
        this.error = MetricSystem.meter(this.name("error"));
        super.start();
    }

    protected void append(ILoggingEvent event) {
        this.all.mark();
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark();
                break;
            }
            case 10000: {
                this.debug.mark();
                break;
            }
            case 20000: {
                this.info.mark();
                break;
            }
            case 30000: {
                this.warn.mark();
                break;
            }
            case 40000: {
                this.error.mark();
                break;
            }
        }
    }
}

