/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OperatingSystemMetricSet
implements MetricSet {
    private final OperatingSystemMXBean operatingSystemMXBean;
    private final ClassLoadingMXBean classLoadingMXBean;

    public OperatingSystemMetricSet() {
        this((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getClassLoadingMXBean());
    }

    public OperatingSystemMetricSet(OperatingSystemMXBean operatingSystemMXBean, ClassLoadingMXBean classLoadingMXBean) {
        this.operatingSystemMXBean = operatingSystemMXBean;
        this.classLoadingMXBean = classLoadingMXBean;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> gauges = new HashMap<String, Object>(16);
        gauges.put(MetricRegistry.name((String)"cpuLoadAvg", (String[])new String[]{"mean"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getProcessCpuLoad() * 100.0;
            }
        });
        gauges.put(MetricRegistry.name((String)"physicalMemory", (String[])new String[]{"total"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getTotalPhysicalMemorySize();
            }
        });
        gauges.put(MetricRegistry.name((String)"physicalMemory", (String[])new String[]{"free"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getFreePhysicalMemorySize();
            }
        });
        gauges.put(MetricRegistry.name((String)"physicalMemory", (String[])new String[]{"used"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getTotalPhysicalMemorySize() - OperatingSystemMetricSet.this.operatingSystemMXBean.getFreePhysicalMemorySize();
            }
        });
        gauges.put(MetricRegistry.name((String)"swapSpace", (String[])new String[]{"total"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getTotalSwapSpaceSize();
            }
        });
        gauges.put(MetricRegistry.name((String)"swapSpace", (String[])new String[]{"free"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getFreeSwapSpaceSize();
            }
        });
        gauges.put(MetricRegistry.name((String)"swapSpace", (String[])new String[]{"free"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.operatingSystemMXBean.getTotalSwapSpaceSize() - OperatingSystemMetricSet.this.operatingSystemMXBean.getFreeSwapSpaceSize();
            }
        });
        gauges.put(MetricRegistry.name((String)"LoadedClassCount", (String[])new String[]{"value"}), new Gauge<Object>(){

            public Object getValue() {
                return OperatingSystemMetricSet.this.classLoadingMXBean.getLoadedClassCount();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }
}

