/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.metric.reporter.cloudmetric.HttpProtocol;
import kd.bos.metric.reporter.cloudmetric.api.measurements.MetricMeasurementTransformer;
import kd.bos.metric.reporter.cloudmetric.measurements.HttpInlinerSender;
import kd.bos.metric.reporter.cloudmetric.measurements.MeasurementReporter;
import kd.bos.metric.reporter.cloudmetric.measurements.Sender;
import kd.bos.metric.reporter.cloudmetric.misc.Miscellaneous;

public class CloudMetricReporter {
    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String fCategory;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter mFilter;
        private boolean fSkipIdleMetrics;
        private ScheduledExecutorService executor;
        private String fToken;
        private HttpProtocol protocol;
        private Map<String, String> tags;
        private MetricMeasurementTransformer measurementTransformer = MetricMeasurementTransformer.NOOP;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.mFilter = MetricFilter.ALL;
            this.tags = new HashMap<String, String>();
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withScheduler(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder category(String category) {
            this.fCategory = category;
            return this;
        }

        public Builder token(String token) {
            this.fToken = token;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.mFilter = filter;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.fSkipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public boolean isSkipIdleMetrics() {
            return this.fSkipIdleMetrics;
        }

        public Builder url(String url) {
            this.protocol = new HttpProtocol(url);
            return this;
        }

        public ScheduledReporter build() {
            Sender s = this.buildSender();
            MeasurementReporter reporter = this.executor == null ? new MeasurementReporter(s, this.fCategory, this.registry, this.mFilter, this.rateUnit, this.durationUnit, this.clock, this.tags, this.measurementTransformer) : new MeasurementReporter(s, this.fCategory, this.registry, this.mFilter, this.rateUnit, this.durationUnit, this.clock, this.tags, this.measurementTransformer, this.executor);
            return reporter;
        }

        public Builder transformer(MetricMeasurementTransformer transformer) {
            Objects.requireNonNull(transformer, "given MetricMeasurementTransformer cannot be null");
            this.measurementTransformer = transformer;
            return this;
        }

        public Builder tag(String tagKey, String tagValue) {
            Miscellaneous.requireNotEmptyParameter(tagKey, "tag");
            Miscellaneous.requireNotEmptyParameter(tagValue, "value");
            this.tags.put(tagKey, tagValue);
            return this;
        }

        private Sender buildSender() {
            if (this.protocol instanceof HttpProtocol) {
                return new HttpInlinerSender(this.protocol, this.fToken);
            }
            throw new IllegalStateException("unsupported protocol: " + this.protocol);
        }
    }
}

