/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.metric.reporter.cloudmetric.VersionNumber;

class VersionNumberMask
extends VersionNumber {
    private static final Pattern _regexp = Pattern.compile("(\\d+)(\\.\\d+)?(\\.\\d+)?([-\\.].+)?");

    public VersionNumberMask(String s) {
        Matcher match = _regexp.matcher(s);
        if (!match.find()) {
            throw new IllegalArgumentException("invalid versionNumber : major.minor(.bugfix)(modifier) :" + s);
        }
        this.major = Integer.parseInt(match.group(1));
        this.minor = -1;
        String group2 = match.group(2);
        String group3 = match.group(3);
        String group4 = match.group(4);
        if (group2 != null && group2.length() > 1) {
            this.minor = Integer.parseInt(group2.substring(1));
        }
        this.bugfix = -1;
        if (group3 != null && group3.length() > 1) {
            this.bugfix = Integer.parseInt(group3.substring(1));
        }
        this.modifier = null;
        if (group4 != null && group4.length() > 1) {
            this.modifier = group4;
        }
    }

    @Override
    public int compareTo(VersionNumber o) {
        int back = 0;
        if (back == 0 && this.major > o.major) {
            back = 1;
        }
        if (back == 0 && this.major < o.major) {
            back = -1;
        }
        if (back == 0 && this.minor > -1 && this.minor > o.minor) {
            back = 1;
        }
        if (back == 0 && this.minor > -1 && this.minor < o.minor) {
            back = -1;
        }
        if (back == 0 && this.bugfix > -1 && this.bugfix > o.bugfix) {
            back = 1;
        }
        if (back == 0 && this.bugfix > -1 && this.bugfix < o.bugfix) {
            back = -1;
        }
        return back;
    }
}

