/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric.measurements;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kd.bos.metric.reporter.cloudmetric.HttpProtocol;
import kd.bos.metric.reporter.cloudmetric.measurements.Measure;
import kd.bos.metric.reporter.cloudmetric.measurements.QueueableSender;
import kd.bos.metric.reporter.cloudmetric.misc.Miscellaneous;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInlinerSender
extends QueueableSender {
    private static final Logger logger = LoggerFactory.getLogger(HttpInlinerSender.class);
    private static int MAX_MEASURES_IN_SINGLE_POST = 5000;
    private final URL writeURL;
    private String token = "";

    public HttpInlinerSender(HttpProtocol protocol2, String token) {
        super(MAX_MEASURES_IN_SINGLE_POST);
        this.token = token;
        try {
            this.writeURL = new URL(protocol2.url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Measure m) {
        if (m == null) {
            return;
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)this.writeURL.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("token", this.token);
            con.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            con.setReadTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            con.setDoOutput(true);
            try (OutputStream wr = con.getOutputStream();){
                String measuresAsString = m.toJson();
                wr.write(measuresAsString.getBytes(Miscellaneous.UTF8));
                wr.flush();
            }
        }
        catch (IOException e) {
            logger.warn(String.format("couldn't send metrics to %s://%s:%s, reason: %s", this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), e.getMessage(), e));
        }
        catch (Exception e) {
            logger.warn(String.format("Exception occurred when send metrics to %s://%s:%s, reason: %s", this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), e.getMessage()));
        }
        finally {
            if (con != null) {
                try {
                    con.getInputStream().close();
                }
                catch (Exception ignore) {
                    logger.error(ignore.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSend(Collection<Measure> measures) {
        if (measures.isEmpty()) {
            return true;
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)this.writeURL.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("token", this.token);
            con.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            con.setReadTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            con.setDoOutput(true);
            try (OutputStream wr = con.getOutputStream();){
                String measuresAsString = measures.toString();
                wr.write(measuresAsString.getBytes(Miscellaneous.UTF8));
                wr.flush();
            }
            int responseCode = con.getResponseCode();
            switch (responseCode) {
                case 204: {
                    logger.debug(String.format("%s Measures sent to %s://%s:%s", measures.size(), this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort()));
                    break;
                }
                case 200: {
                    logger.info(String.format("%s Measures sent to %s://%s:%s but not saved by infludb, reason:\n%s", measures.size(), this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), Miscellaneous.readFrom(con.getInputStream())));
                    break;
                }
                default: {
                    logger.info(String.format("failed to send %s Measures to %s://%s:%s, HTTP CODE received: %s\n", measures.size(), this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), responseCode, Miscellaneous.readFrom(con.getInputStream())));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.warn(String.format("couldn't send metrics to %s://%s:%s, reason: %s", this.writeURL.getProtocol(), this.writeURL.getHost(), this.writeURL.getPort(), e.getMessage(), e));
        }
        finally {
            if (con != null) {
                try {
                    con.getInputStream().close();
                }
                catch (Exception ignore) {
                    logger.error(ignore.getMessage());
                }
            }
        }
        return false;
    }
}

