/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric.measurements;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Measure {
    private String category;
    private String name;
    private Map<String, String> tags = new HashMap<String, String>();
    private Number nValue;
    private long fTimestamp;
    private String metricType;
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public Measure(String category, String name) {
        this.category = category;
        this.name = name;
    }

    public Measure value(Number value) {
        this.nValue = value;
        return this;
    }

    public void setTags(Map<String, String> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.putAll(tags);
        }
    }

    public String getMetricType() {
        return this.metricType;
    }

    public Measure setMetricType(String metricType) {
        this.metricType = metricType;
        return this;
    }

    public void setTimestamp(long timestamp) {
        this.fTimestamp = timestamp;
    }

    public Measure timestamp(long timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public Measure addTag(String tagKey, String tagValue) {
        this.tags.put(tagKey, tagValue);
        return this;
    }

    public Measure addTag(Map<String, String> tags) {
        this.tags.putAll(tags);
        return this;
    }

    public String toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("category", this.category);
        map.put("metricName", this.name);
        map.put("dimensionValues", this.tags);
        map.put("timestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.fTimestamp)));
        map.put("value", this.nValue);
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (IOException e) {
            throw new RuntimeException("Won't go here.", e);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Number getValue() {
        return this.nValue;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }
}

