/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.cloudmetric.measurements;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.metric.reporter.cloudmetric.api.measurements.MetricMeasurementTransformer;
import kd.bos.metric.reporter.cloudmetric.measurements.Measure;
import kd.bos.metric.reporter.cloudmetric.measurements.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(MeasurementReporter.class);
    private final Sender sender;
    private final Clock clock;
    private final String category;
    private final Map<String, String> baseTags;
    private final MetricMeasurementTransformer transformer;

    public MeasurementReporter(Sender sender, String category, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, Map<String, String> baseTags, MetricMeasurementTransformer transformer, ScheduledExecutorService executor) {
        super(registry, "measurement-reporter", filter, rateUnit, durationUnit, executor);
        this.category = category;
        this.baseTags = baseTags;
        this.sender = sender;
        this.clock = clock;
        this.transformer = transformer;
    }

    public MeasurementReporter(Sender sender, String category, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, Map<String, String> baseTags, MetricMeasurementTransformer transformer) {
        super(registry, "measurement-reporter", filter, rateUnit, durationUnit);
        this.category = category;
        this.baseTags = baseTags;
        this.sender = sender;
        this.clock = clock;
        this.transformer = transformer;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime();
        this.sendGauge(gauges, timestamp);
        this.sendCounter(counters, timestamp);
        this.sendHistogram(histograms, timestamp);
        this.sendMeter(meters, timestamp);
        this.sendTimer(timers, timestamp);
        this.sender.flush();
    }

    private void sendGauge(SortedMap<String, Gauge> gauges, long timestamp) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            try {
                Measure measure;
                if (!this.enableSend(entry.getKey()) || (measure = this.fromGauge(entry.getKey(), entry.getValue(), timestamp)) == null) continue;
                this.sender.send(measure);
            }
            catch (Exception e) {
                log.debug("report " + entry.getKey() + " error!", (Throwable)e);
            }
        }
    }

    private void sendCounter(SortedMap<String, Counter> counters, long timestamp) {
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            try {
                Measure measure;
                if (!this.enableSend(entry.getKey()) || (measure = this.fromCounter(entry.getKey(), entry.getValue(), timestamp)) == null) continue;
                this.sender.send(measure);
            }
            catch (Exception e) {
                log.debug("report " + entry.getKey() + " error!", (Throwable)e);
            }
        }
    }

    private void sendHistogram(SortedMap<String, Histogram> histograms, long timestamp) {
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            try {
                Measure measure;
                if (!this.enableSend(entry.getKey()) || (measure = this.fromHistogram(entry.getKey(), entry.getValue(), timestamp)) == null) continue;
                this.sender.send(measure);
            }
            catch (Exception e) {
                log.debug("report " + entry.getKey() + " error!", (Throwable)e);
            }
        }
    }

    private void sendMeter(SortedMap<String, Meter> meters, long timestamp) {
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            try {
                Measure measure;
                if (!this.enableSend(entry.getKey()) || (measure = this.fromMeter(entry.getKey(), entry.getValue(), timestamp)) == null) continue;
                this.sender.send(measure);
            }
            catch (Exception e) {
                log.debug("report " + entry.getKey() + " error!", (Throwable)e);
            }
        }
    }

    private void sendTimer(SortedMap<String, Timer> timers, long timestamp) {
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            try {
                Measure measure;
                if (!this.enableSend(entry.getKey()) || (measure = this.fromTimer(entry.getKey(), entry.getValue(), timestamp)) == null) continue;
                this.sender.send(measure);
            }
            catch (Exception e) {
                log.debug("report " + entry.getKey() + " error!", (Throwable)e);
            }
        }
    }

    private boolean enableSend(String key) {
        return true;
    }

    private Measure fromTimer(String metricName, Timer t, long timestamp) {
        Snapshot snapshot = t.getSnapshot();
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.category, this.transformer.measurementName(metricName)).setMetricType(Timer.class.getSimpleName()).timestamp(timestamp).addTag(tags).value(this.convertDuration(snapshot.getMean()));
        return measure;
    }

    private Measure fromMeter(String metricName, Meter mt, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.category, this.transformer.measurementName(metricName)).setMetricType(Meter.class.getSimpleName()).timestamp(timestamp).addTag(tags).value(mt.getCount());
        return measure;
    }

    private Measure fromHistogram(String metricName, Histogram h, long timestamp) {
        Snapshot snapshot = h.getSnapshot();
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.category, this.transformer.measurementName(metricName)).setMetricType(Histogram.class.getSimpleName()).timestamp(timestamp).addTag(tags).value(this.convertDuration(snapshot.getMean()));
        return measure;
    }

    private Measure fromCounter(String metricName, Counter c, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.category, this.transformer.measurementName(metricName)).setMetricType(Counter.class.getSimpleName()).timestamp(timestamp).addTag(tags).value(c.getCount());
        return measure;
    }

    private Measure fromGauge(String metricName, Gauge g, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(this.transformer.tags(metricName));
        Measure measure = new Measure(this.category, this.transformer.measurementName(metricName)).setMetricType(Gauge.class.getSimpleName()).timestamp(timestamp).addTag(tags);
        Object o = g.getValue();
        if (o == null) {
            return null;
        }
        if (!(o instanceof Number)) {
            return null;
        }
        measure.value((Number)o);
        return measure;
    }
}

