/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.elasticsearch;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.StorageReporterFactory;
import kd.bos.metric.reporter.cloudmetric.misc.Miscellaneous;
import kd.bos.metric.reporter.elasticsearch.MetricsPoJo;
import kd.bos.util.JmxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchReporter.class);
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final String fullGcTime = "kd.metrics.jvm.gc.G1-Old-Generation.time";
    private static final String fullGcCount = "kd.metrics.jvm.gc.G1-Old-Generation.count";
    private static final String youngGcCount = "kd.metrics.jvm.gc.G1-Young-Generation.count";
    private static final String youngGcTime = "kd.metrics.jvm.gc.G1-Young-Generation.time";
    private static final String[] SLOWSQL_KEYS = new String[]{"kd.metrics.sql.execute.slow1second", "kd.metrics.sql.execute.slow5second", "kd.metrics.sql.execute.slow10second", "kd.metrics.sql.execute.slow30second", "kd.metrics.sql.execute.slow60second"};
    private static final String GC_NAME_PRE = "kd.metrics.jvm.gc";
    private static final Map<String, Long> meterRecordMap = new ConcurrentHashMap<String, Long>(6);
    private static final Map<String, Long> gcRecordMap = new ConcurrentHashMap<String, Long>(4);
    private final List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final ArrayBlockingQueue<MetricsPoJo> metrics = new ArrayBlockingQueue(10000);
    private final AtomicInteger count = new AtomicInteger(0);

    protected ElasticSearchReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.init();
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private final void init() {
        Thread reportThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        MetricsPoJo poll;
                        if ((poll = this.metrics.poll(9000L, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        StorageReporterFactory.getStorageReporter(GovernDataType.METRICS).reporter(poll);
                    }
                }
                catch (Exception e) {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }, "metrics-report");
        reportThread.setDaemon(true);
        reportThread.start();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        block3: {
            long currentTimeMillis = System.currentTimeMillis();
            boolean aBoolean = Boolean.parseBoolean(System.getProperty("gov.metric.enable", "true"));
            if (aBoolean && !gauges.isEmpty()) {
                try {
                    HashMap<String, Gauge> hashMap = new HashMap<String, Gauge>(gauges);
                    hashMap.put("kd.metrics.servletfilter.requestTimer", () -> {
                        Object mean = JmxUtils.getAtt((String)"kd.metrics:name=kd.metrics.servletfilter.requestTimer,type=timers", (String)"Mean");
                        return mean == null ? Integer.valueOf(0) : mean;
                    });
                    hashMap.putAll(this.getGCInfo());
                    hashMap.putAll(this.convertMeters(meters));
                    this.metrics.offer(new MetricsPoJo<Gauge>("gauge", currentTimeMillis, hashMap), 0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    logger.warn("queue is full, metrics report busy");
                    if (this.count.getAndIncrement() < 3) break block3;
                    this.metrics.clear();
                    this.count.set(0);
                }
            }
        }
    }

    private Map<String, Gauge> convertMeters(SortedMap<String, Meter> meters) {
        Map<String, Gauge> gaugeMap = this.getSlowSqlInfo(meters);
        Map<String, Gauge> logDiscardCountMap = this.getLogDiscardCount(meters);
        gaugeMap.putAll(logDiscardCountMap);
        return gaugeMap;
    }

    private Map<String, Gauge> getLogDiscardCount(SortedMap<String, Meter> meters) {
        String meterName = "kd.metrics.log.kafka.discardCount";
        HashMap<String, Gauge> gaugeMap = new HashMap<String, Gauge>(1);
        Meter tempDbMeter = (Meter)meters.get(meterName);
        if (tempDbMeter != null) {
            long count = tempDbMeter.getCount();
            Long lastCount = meterRecordMap.get(meterName);
            Gauge tempDbGauge = () -> lastCount == null ? 0L : count - lastCount;
            gaugeMap.put(meterName, tempDbGauge);
            meterRecordMap.put(meterName, count);
        }
        return gaugeMap;
    }

    private Map<String, Gauge> getSlowSqlInfo(SortedMap<String, Meter> meters) {
        HashMap<String, Gauge> gaugeMap = new HashMap<String, Gauge>(8);
        for (String tempDbKey : SLOWSQL_KEYS) {
            Meter tempDbMeter = (Meter)meters.get(tempDbKey);
            if (tempDbMeter == null) continue;
            long count = tempDbMeter.getCount();
            Long lastCount = meterRecordMap.get(tempDbKey);
            Gauge tempDbGauge = () -> lastCount == null ? 0L : count - lastCount;
            gaugeMap.put(tempDbKey, tempDbGauge);
            meterRecordMap.put(tempDbKey, count);
        }
        return gaugeMap;
    }

    private Map<String, Gauge> getGCInfo() {
        HashMap<String, Gauge> gauges = new HashMap<String, Gauge>(8);
        try {
            for (GarbageCollectorMXBean gc : this.gcMxBeans) {
                String name = WHITESPACE.matcher(gc.getName()).replaceAll("-");
                String metricCount = MetricRegistry.name((String)name, (String[])new String[]{"count"});
                String metricTime = MetricRegistry.name((String)name, (String[])new String[]{"time"});
                String durationCount = MetricRegistry.name((String)GC_NAME_PRE, (String[])new String[]{"collectDuration", metricCount});
                Long lastCount = gcRecordMap.get(durationCount);
                long lastCountVal = lastCount == null ? 0L : lastCount;
                gauges.put(durationCount, () -> gc.getCollectionCount() - lastCountVal);
                String durationTime = MetricRegistry.name((String)GC_NAME_PRE, (String[])new String[]{"collectDuration", metricTime});
                Long lastTime = gcRecordMap.get(durationTime);
                long lastTimeVal = lastCount == null ? 0L : lastTime;
                gauges.put(durationTime, () -> gc.getCollectionTime() - lastTimeVal);
                gauges.put(metricCount, gc::getCollectionCount);
                gauges.put(metricTime, gc::getCollectionTime);
                gcRecordMap.put(durationCount, gc.getCollectionCount());
                gcRecordMap.put(durationTime, gc.getCollectionTime());
            }
        }
        catch (Exception e) {
            logger.warn("get gc info exception");
        }
        return gauges;
    }

    private String getGcType() {
        try {
            for (GarbageCollectorMXBean gcMxBean : this.gcMxBeans) {
                if (!gcMxBean.getName().contains("G1")) continue;
                return "G1";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "default";
    }

    public static class Builder {
        private final MetricRegistry registry;
        private final Map<String, String> tags;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter metricFilter;
        private boolean fSkipIdleMetrics;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.metricFilter = MetricFilter.ALL;
            this.tags = new HashMap<String, String>();
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.metricFilter = filter;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.fSkipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public boolean isSkipIdleMetrics() {
            return this.fSkipIdleMetrics;
        }

        public ScheduledReporter build() {
            ElasticSearchReporter reporter = new ElasticSearchReporter(this.registry, "elasticsearch-report", this.metricFilter, this.rateUnit, this.durationUnit);
            return reporter;
        }

        public Builder tag(String tagKey, String tagValue) {
            Miscellaneous.requireNotEmptyParameter(tagKey, "tag");
            Miscellaneous.requireNotEmptyParameter(tagValue, "value");
            this.tags.put(tagKey, tagValue);
            return this;
        }
    }
}

