/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.kafka;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kd.bos.metric.reporter.cloudmetric.misc.Miscellaneous;
import kd.bos.metric.reporter.kafka.IKafkaSender;
import kd.bos.metric.reporter.kafka.KafkaMessage;
import kd.bos.metric.reporter.kafka.KafkaSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(KafkaReporter.class);
    private static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String DEFAULT_SECURITY_PROTOCOL = "SASL_PLAINTEXT";
    private static final String DEFAULT_SASL_MECHANISM = "PLAIN";
    private final IKafkaSender sender;
    private final MetricRegistry registry;
    private final ObjectMapper mapper;
    private final String topic;

    public KafkaReporter(IKafkaSender sender, String topic, String category, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock) {
        super(registry, "kafka-reporter", filter, rateUnit, durationUnit);
        this.sender = sender;
        this.topic = topic;
        this.registry = registry;
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(rateUnit, durationUnit, false));
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            StringWriter report = new StringWriter();
            this.mapper.writeValue((Writer)report, (Object)this.registry);
            this.sender.send(new KafkaMessage<String>(this.topic, report.toString()));
        }
        catch (IOException e) {
            log.warn("Exception occurred when send metrics to kafka,the topic is {}, reason: {}", (Object)this.topic, (Object)e);
        }
    }

    private Map<String, Object> addPrefix(SortedMap<String, ?> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            result.put("kafka_metrics" + entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static class Builder {
        private String KAFKA_TOPIC = null;
        private final MetricRegistry registry;
        private Map<String, String> tags;
        private Clock clock;
        private String fCategory;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter metricFilter;
        private boolean fSkipIdleMetrics;
        private IKafkaSender sender;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.metricFilter = MetricFilter.ALL;
            this.tags = new HashMap<String, String>();
        }

        public Builder category(String category) {
            this.fCategory = category;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.metricFilter = filter;
            return this;
        }

        public Builder getSender(String host, String topic, String user, String password) {
            this.KAFKA_TOPIC = topic;
            Properties props = this.getProducerProperties(host, user, password);
            this.sender = new KafkaSender(props);
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.fSkipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public boolean isSkipIdleMetrics() {
            return this.fSkipIdleMetrics;
        }

        public ScheduledReporter build() {
            if (this.sender == null) {
                throw new NullPointerException("Sender must be provided");
            }
            KafkaReporter reporter = new KafkaReporter(this.sender, this.KAFKA_TOPIC, this.fCategory, this.registry, this.metricFilter, this.rateUnit, this.durationUnit, this.clock);
            return reporter;
        }

        public Builder tag(String tagKey, String tagValue) {
            Miscellaneous.requireNotEmptyParameter(tagKey, "tag");
            Miscellaneous.requireNotEmptyParameter(tagValue, "value");
            this.tags.put(tagKey, tagValue);
            return this;
        }

        private Properties getProducerProperties(String host, String user, String password) {
            Properties properties = new Properties();
            properties.setProperty(KafkaReporter.BOOTSTRAP_SERVERS_CONFIG, host);
            properties.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            properties.setProperty("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
            properties.setProperty("acks", "0");
            properties.setProperty("max.request.size", String.valueOf(0xA00000));
            if (user != null && password != null) {
                String config = Builder.getKafkaAuthConfig(user, password);
                properties.setProperty(KafkaReporter.SASL_JAAS_CONFIG, config);
                properties.setProperty(KafkaReporter.SASL_MECHANISM, KafkaReporter.DEFAULT_SASL_MECHANISM);
                properties.setProperty(KafkaReporter.SECURITY_PROTOCOL, KafkaReporter.DEFAULT_SECURITY_PROTOCOL);
            }
            return properties;
        }

        private static String getKafkaAuthConfig(String userName, String password) {
            return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + userName + "\" password=\"" + password + "\";";
        }
    }
}

