/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metric.reporter.spi;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import kd.bos.metric.reporter.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPIReport
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(SPIReport.class);
    private final MetricRegistry registry;
    private final ObjectMapper mapper;
    private final Report report;

    public SPIReport(Report spiReport, MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.report = spiReport;
        this.registry = registry;
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(rateUnit, durationUnit, false));
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            StringWriter sw = new StringWriter();
            this.mapper.writeValue((Writer)sw, (Object)this.registry);
            this.report.report(sw.toString());
        }
        catch (IOException e) {
            log.warn("Exception occurred when send metrics by SPI,the class is {}, reason: {}", (Object)this.report.getClass().getName(), (Object)e);
        }
    }
}

