/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.sdk;

import io.prometheus.client.Counter;
import java.util.Arrays;
import java.util.stream.Stream;
import kd.bos.instance.Instance;
import kd.bos.monitor.sdk.MonitorSDKUtils;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KDCounter.class);
    private Counter counter;
    private boolean isSetSystemLabels = false;

    public static KDCounter build(String name, String help, String ... labelNames) {
        KDCounter kdCounter = new KDCounter();
        if (!MonitorSDKUtils.bizMonitorEnable()) {
            return kdCounter;
        }
        if (MonitorSDKUtils.TOTAL_COLLECTOR.get() >= MonitorSDKUtils.MAX_TOTAL_COLLECTOR) {
            LOGGER.debug("The number of Collectors has reached the maximum limit.");
            return kdCounter;
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)help)) {
            LOGGER.debug("name or help is empty.");
            return kdCounter;
        }
        name = MonitorSDKUtils.truncateString(name, 100);
        help = MonitorSDKUtils.truncateString(help, 200);
        try {
            Counter.Builder builder = (Counter.Builder)((Counter.Builder)Counter.build().name("b_" + name)).help(help);
            if (labelNames != null && labelNames.length > 0) {
                if (labelNames.length > 5) {
                    labelNames = Arrays.copyOf(labelNames, 5);
                }
                MonitorSDKUtils.truncateStrings(labelNames, 100);
                String[] finalLabelNames = (String[])Stream.concat(Stream.of(MonitorSDKUtils.SYS_LABEL_NAMES), Stream.of(labelNames)).toArray(String[]::new);
                builder.labelNames(finalLabelNames);
            } else {
                builder.labelNames(MonitorSDKUtils.SYS_LABEL_NAMES);
            }
            kdCounter.counter = (Counter)builder.register();
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
        MonitorSDKUtils.TOTAL_COLLECTOR.incrementAndGet();
        return kdCounter;
    }

    public static KDCounter build(String name, String help) {
        return KDCounter.build(name, help, new String[0]);
    }

    public Counter.Child labels(String ... labelValues) {
        Counter.Child child;
        if (!MonitorSDKUtils.bizMonitorEnable() || this.counter == null) {
            Counter.Child child2 = new Counter.Child();
            return child2;
        }
        try {
            String[] sysLabels = new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()};
            if (labelValues.length > 5) {
                labelValues = Arrays.copyOf(labelValues, 5);
            }
            MonitorSDKUtils.truncateStrings(labelValues, 100);
            String[] labels = (String[])Stream.concat(Stream.of(sysLabels), Stream.of(labelValues)).toArray(String[]::new);
            child = (Counter.Child)this.counter.labels(labels);
            this.isSetSystemLabels = true;
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
            child = new Counter.Child();
        }
        return child;
    }

    public void inc() {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.counter == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Counter.Child)this.counter.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).inc();
            } else {
                this.counter.inc();
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public void inc(double amt) {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.counter == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Counter.Child)this.counter.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).inc(amt);
            } else {
                this.counter.inc(amt);
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public Counter getCounter() {
        return this.counter;
    }
}

