/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.sdk;

import io.prometheus.client.Gauge;
import java.util.Arrays;
import java.util.stream.Stream;
import kd.bos.instance.Instance;
import kd.bos.monitor.sdk.MonitorSDKUtils;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDGauge {
    private static final Logger LOGGER = LoggerFactory.getLogger(KDGauge.class);
    private Gauge gauge;
    private boolean isSetSystemLabels = false;

    public static KDGauge build(String name, String help, String ... labelNames) {
        KDGauge kdGauge = new KDGauge();
        if (!MonitorSDKUtils.bizMonitorEnable()) {
            return kdGauge;
        }
        if (MonitorSDKUtils.TOTAL_COLLECTOR.get() >= MonitorSDKUtils.MAX_TOTAL_COLLECTOR) {
            LOGGER.debug("The number of Collectors has reached the maximum limit.");
            return kdGauge;
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)help)) {
            LOGGER.warn("name or help is empty.");
            return kdGauge;
        }
        name = MonitorSDKUtils.truncateString(name, 100);
        help = MonitorSDKUtils.truncateString(help, 200);
        try {
            Gauge.Builder builder = (Gauge.Builder)((Gauge.Builder)Gauge.build().name("b_" + name)).help(help);
            if (labelNames != null && labelNames.length > 0) {
                if (labelNames.length > 5) {
                    labelNames = Arrays.copyOf(labelNames, 5);
                }
                MonitorSDKUtils.truncateStrings(labelNames, 100);
                String[] finalLabelNames = (String[])Stream.concat(Stream.of(MonitorSDKUtils.SYS_LABEL_NAMES), Stream.of(labelNames)).toArray(String[]::new);
                builder.labelNames(finalLabelNames);
            } else {
                builder.labelNames(MonitorSDKUtils.SYS_LABEL_NAMES);
            }
            kdGauge.gauge = (Gauge)builder.register();
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
        MonitorSDKUtils.TOTAL_COLLECTOR.incrementAndGet();
        return kdGauge;
    }

    public static KDGauge build(String name, String help) {
        return KDGauge.build(name, help, new String[0]);
    }

    public Gauge.Child labels(String ... labelValues) {
        Gauge.Child child;
        if (!MonitorSDKUtils.bizMonitorEnable() || this.gauge == null) {
            Gauge.Child child2 = new Gauge.Child();
            return child2;
        }
        try {
            String[] sysLabels = new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()};
            if (labelValues.length > 5) {
                labelValues = Arrays.copyOf(labelValues, 5);
            }
            MonitorSDKUtils.truncateStrings(labelValues, 100);
            String[] labels = (String[])Stream.concat(Stream.of(sysLabels), Stream.of(labelValues)).toArray(String[]::new);
            child = (Gauge.Child)this.gauge.labels(labels);
            this.isSetSystemLabels = true;
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
            child = new Gauge.Child();
        }
        return child;
    }

    public void set(double val) {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.gauge == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Gauge.Child)this.gauge.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).set(val);
            } else {
                this.gauge.set(val);
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public void inc() {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.gauge == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Gauge.Child)this.gauge.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).inc();
            } else {
                this.gauge.inc();
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public void inc(double amt) {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.gauge == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Gauge.Child)this.gauge.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).inc(amt);
            } else {
                this.gauge.inc(amt);
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public void dec() {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.gauge == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Gauge.Child)this.gauge.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).dec();
            } else {
                this.gauge.dec();
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public void dec(double amt) {
        if (!MonitorSDKUtils.bizMonitorEnable() || this.gauge == null) {
            return;
        }
        try {
            if (!this.isSetSystemLabels) {
                ((Gauge.Child)this.gauge.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).dec(amt);
            } else {
                this.gauge.dec(amt);
            }
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public Gauge getGauge() {
        return this.gauge;
    }
}

