/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.sdk;

import io.prometheus.client.Histogram;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import kd.bos.instance.Instance;
import kd.bos.monitor.sdk.MonitorSDKUtils;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDHistogram {
    private static final Logger LOGGER = LoggerFactory.getLogger(KDHistogram.class);
    @Nullable
    private Histogram histogram;

    private KDHistogram() {
    }

    public static KDHistogram build(String name, String help) {
        return KDHistogram.build(name, help, new double[0], new String[0]);
    }

    public static KDHistogram build(String name, String help, double[] buckets) {
        return KDHistogram.build(name, help, buckets, new String[0]);
    }

    public static KDHistogram build(String name, String help, String ... labelNames) {
        return KDHistogram.build(name, help, new double[0], labelNames);
    }

    public static KDHistogram build(String name, String help, double[] buckets, String ... labelNames) {
        KDHistogram kdHistogram = new KDHistogram();
        if (!MonitorSDKUtils.bizMonitorEnable()) {
            return kdHistogram;
        }
        if (MonitorSDKUtils.TOTAL_COLLECTOR.get() >= MonitorSDKUtils.MAX_TOTAL_COLLECTOR) {
            LOGGER.debug("The number of Collectors has reached the maximum limit.");
            return kdHistogram;
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)help)) {
            LOGGER.warn("name or help is empty.");
            return kdHistogram;
        }
        name = MonitorSDKUtils.truncateString(name, 100);
        help = MonitorSDKUtils.truncateString(help, 200);
        try {
            Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)Histogram.build().name("b_" + name)).help(help);
            if (labelNames != null && labelNames.length > 0) {
                if (labelNames.length > 5) {
                    labelNames = Arrays.copyOf(labelNames, 5);
                }
                MonitorSDKUtils.truncateStrings(labelNames, 100);
                String[] finalLabelNames = (String[])Stream.concat(Stream.of(MonitorSDKUtils.SYS_LABEL_NAMES), Stream.of(labelNames)).toArray(String[]::new);
                builder.labelNames(finalLabelNames);
            } else {
                builder.labelNames(MonitorSDKUtils.SYS_LABEL_NAMES);
            }
            if (buckets != null && buckets.length > 0) {
                builder.buckets(buckets);
            }
            kdHistogram.histogram = (Histogram)builder.register();
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
        MonitorSDKUtils.TOTAL_COLLECTOR.incrementAndGet();
        return kdHistogram;
    }

    public Timer startTimer() {
        if (this.histogram == null) {
            return new Child().startTimer();
        }
        try {
            return new Child((Histogram.Child)this.histogram.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).startTimer();
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
            return new Child().startTimer();
        }
    }

    public void observe(double amt) {
        if (this.histogram == null) {
            return;
        }
        try {
            new Child((Histogram.Child)this.histogram.labels(new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()})).observe(amt);
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
    }

    public Child labels(String ... labelValues) {
        Child customLabelsChild = new Child();
        if (!MonitorSDKUtils.bizMonitorEnable() || this.histogram == null) {
            return customLabelsChild;
        }
        try {
            String[] sysLabels = new String[]{MonitorSDKUtils.getAppName(), MonitorSDKUtils.getInstanceId(), MonitorSDKUtils.getIp(), MonitorSDKUtils.getTenantId(), Instance.getClusterName()};
            if (labelValues.length > 5) {
                labelValues = Arrays.copyOf(labelValues, 5);
            }
            MonitorSDKUtils.truncateStrings(labelValues, 100);
            String[] labels = (String[])Stream.concat(Stream.of(sysLabels), Stream.of(labelValues)).toArray(String[]::new);
            customLabelsChild = new Child((Histogram.Child)this.histogram.labels(labels));
        }
        catch (Exception e) {
            LOGGER.debug("An exception that was encountered.", (Throwable)e);
        }
        return customLabelsChild;
    }

    public static class Timer {
        private Histogram.Timer delegate;

        private Timer() {
        }

        private Timer(Histogram.Timer delegate) {
            this.delegate = delegate;
        }

        public double observeDuration() {
            if (!MonitorSDKUtils.bizMonitorEnable() || this.delegate == null) {
                return 0.0;
            }
            try {
                return this.delegate.observeDuration();
            }
            catch (Exception e) {
                LOGGER.debug("An exception that was encountered.", (Throwable)e);
                return 0.0;
            }
        }
    }

    public static class Child {
        private Histogram.Child delegate;

        private Child() {
        }

        private Child(Histogram.Child child) {
            this.delegate = child;
        }

        public Timer startTimer() {
            if (!MonitorSDKUtils.bizMonitorEnable() || this.delegate == null) {
                return new Timer();
            }
            return new Timer(this.delegate.startTimer());
        }

        public void observe(double amt) {
            if (!MonitorSDKUtils.bizMonitorEnable() || this.delegate == null) {
                return;
            }
            try {
                this.delegate.observe(amt);
            }
            catch (Exception e) {
                LOGGER.debug("An exception that was encountered.", (Throwable)e);
            }
        }
    }
}

