/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.sdk;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.instance.Instance;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorSDKUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorSDKUtils.class);
    public static final String KEY_SUFFIX = "b_";
    public static final String LABEL_APP_NAME = "appName";
    public static final String LABEL_INSTANCE_ID = "instanceId";
    public static final String LABEL_IP = "ip";
    public static final String LABEL_TENANT_ID = "tenantId";
    public static final String LABEL_CLUSTER_NAME = "clusterName";
    public static final int MAX_TOTAL_CUSTOM_LABELS = 5;
    public static final String MONITOR_BIZ_ENABLE_KEY = "monitor.biz.enable";
    public static final String MONITOR_BIZ_METRICS_COMP_DISABLE_KEY = "monitor.biz.compression.disable";
    public static final String[] SYS_LABEL_NAMES = new String[]{"appName", "instanceId", "ip", "tenantId", "clusterName"};
    public static final int NAME_MAX_LENGTH = 100;
    public static final int HELP_MAX_LENGTH = 200;
    public static final int LABEL_NAME_MAX_LENGTH = 100;
    public static final int LABEL_VALUE_MAX_LENGTH = 100;
    public static int MAX_TOTAL_COLLECTOR = 1000;
    public static final AtomicInteger TOTAL_COLLECTOR = new AtomicInteger(0);

    static String getAppName() {
        return Instance.getAppName();
    }

    static String getInstanceId() {
        return Instance.getInstanceId();
    }

    static String getIp() {
        String ret = "";
        try {
            ret = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.debug(e.getMessage());
        }
        return ret;
    }

    public static String getTenantId() {
        String ret = "";
        try {
            Class<?> requestContextClass = Class.forName("kd.bos.context.RequestContext");
            Method methodGet = requestContextClass.getMethod("get", new Class[0]);
            Object tenantObject = methodGet.invoke(null, new Object[0]);
            Method methodTenantId = tenantObject.getClass().getMethod("getTenantId", new Class[0]);
            return (String)methodTenantId.invoke(tenantObject, new Object[0]);
        }
        catch (Exception exception) {
            return ret;
        }
    }

    static boolean bizMonitorEnable() {
        boolean isEnable = true;
        try {
            String enableValue = System.getProperty(MONITOR_BIZ_ENABLE_KEY);
            if (enableValue != null) {
                isEnable = !"false".equals(enableValue);
            } else {
                String monitorBizEnableKey;
                String tenantId = MonitorSDKUtils.getTenantId();
                if (!StringUtils.isEmpty((String)tenantId) && "false".equals(enableValue = System.getProperty(monitorBizEnableKey = tenantId + "_" + MONITOR_BIZ_ENABLE_KEY))) {
                    isEnable = false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("isBizMonitorEnabled failed", (Throwable)e);
        }
        return isEnable;
    }

    public static void truncateStrings(String[] array, int maxLength) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            String str = array[i];
            if (str == null || str.length() <= maxLength) continue;
            array[i] = str.substring(0, maxLength);
        }
    }

    public static String truncateString(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        return str.length() > maxLength ? str.substring(0, maxLength) : str;
    }
}

