/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.sdk;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledCollector {
    private static final Logger log = LoggerFactory.getLogger(ScheduledCollector.class);
    private static final Map<String, MetricUpdateHandler> UPDATE_HANDLER_MAP = new ConcurrentHashMap<String, MetricUpdateHandler>();
    private static int DELAY_MILLISECONDS = 3000;
    private static int INITIAL_DELAY_MILLISECONDS = 60000;
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public static void registerHandler(String className, MetricUpdateHandler handler) {
        UPDATE_HANDLER_MAP.putIfAbsent(className, handler);
    }

    static {
        ConfigurationUtil.observeInteger((String)"biz.monitor.delay.millisecond", (int)3000, v -> {
            DELAY_MILLISECONDS = v;
        });
        ConfigurationUtil.observeInteger((String)"biz.monitor.initial.delay.millisecond", (int)60000, v -> {
            INITIAL_DELAY_MILLISECONDS = v;
        });
        executor.scheduleWithFixedDelay(() -> UPDATE_HANDLER_MAP.forEach((k, handler) -> {
            if (handler != null) {
                try {
                    handler.update();
                }
                catch (Exception t) {
                    log.error("ScheduledCollector update error, metric from " + k, (Throwable)t);
                }
            }
        }), INITIAL_DELAY_MILLISECONDS, DELAY_MILLISECONDS, TimeUnit.MILLISECONDS);
    }

    @FunctionalInterface
    public static interface MetricUpdateHandler {
        public void update();
    }
}

