/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.perflog;

import java.util.HashMap;
import java.util.Map;
import kd.bos.perflog.PerfLoggerConfig;
import kd.bos.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PerfLogger {
    private static Logger logger = LoggerFactory.getLogger(PerfLogger.class);
    private static PerfLogger instance;

    public static void setInstance(PerfLogger logger) {
        instance = logger;
    }

    public static void log(String type, long costsInMillSeconds, String tags) {
        HashMap<String, Object> logObject = new HashMap<String, Object>();
        if (tags != null && tags.length() > 0) {
            String[] tagArray;
            for (String entry : tagArray = tags.split(",")) {
                if (!entry.contains(":")) continue;
                int index = entry.indexOf(58);
                logObject.put(entry.substring(0, index), entry.substring(index + 1));
            }
        }
        PerfLogger.logCost(type, costsInMillSeconds, logObject);
    }

    public static void logCost(String type, long costsInMillSeconds, Map<String, Object> tagMap) {
        if (instance != null && PerfLoggerConfig.isLogEnable(type)) {
            HashMap<String, Object> logObject = new HashMap<String, Object>();
            logObject.put("perfLog-type", type);
            logObject.put("perfLog-cost", costsInMillSeconds);
            if (tagMap != null && tagMap.size() > 0) {
                logObject.putAll(tagMap);
            }
            String msg = "";
            try {
                msg = JSONUtils.toString(logObject);
            }
            catch (Exception ex) {
                logger.warn("PerfLogger.logCost error:", (Throwable)ex);
            }
            instance.log0(msg);
        }
    }

    protected abstract void log0(String var1);
}

