/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.slowlog;

import kd.bos.monitor.sdk.KDCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlowLogger {
    private static final Logger logger = LoggerFactory.getLogger(SlowLogger.class);
    private static final String LEVEL = System.getProperty("slowlogger.level", "error");
    private static final KDCounter COUNTER_SLOW_WEB = KDCounter.build("slow_logger_web", "Number of web slow log");
    private static final KDCounter COUNTER_SLOW_RPC = KDCounter.build("slow_logger_rpc", "Number of rpc slow log");
    private static final KDCounter COUNTER_SLOW_JDBC = KDCounter.build("slow_logger_jdbc", "Number of jdbc slow log");
    private static SlowLogger instance;

    public static void setInstance(SlowLogger logger) {
        instance = logger;
    }

    public static void log(String message) {
        if (instance != null) {
            instance.log0(message);
        }
    }

    protected abstract void log0(String var1);

    public static void log(String message, Object ... args) {
        if ("warn".equalsIgnoreCase(LEVEL)) {
            logger.warn(message, args);
        } else if ("info".equalsIgnoreCase(LEVEL)) {
            logger.info(message, args);
        } else if ("debug".equalsIgnoreCase(LEVEL)) {
            logger.debug(message, args);
        } else {
            logger.error(message, args);
        }
    }

    public static void count(String type) {
        boolean result = false;
        try {
            String name = System.getProperty("SlowLogger.monitor.enable", "true");
            result = Boolean.parseBoolean(name);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (result) {
            switch (type) {
                case "WEB": {
                    COUNTER_SLOW_WEB.inc();
                    break;
                }
                case "RPC": {
                    COUNTER_SLOW_RPC.inc();
                    break;
                }
                case "JDBC": {
                    COUNTER_SLOW_JDBC.inc();
                    break;
                }
            }
        }
    }
}

