/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace;

import kd.bos.trace.tracer.EnableConfig;
import kd.bos.util.SystemProperties;

public class TraceConfig {
    private static final String KEY_TRACE_DEBUG = "gov.trace.debug";
    private static final String KEY_TRACE_ENABLE = "gov.trace.enable";
    private static final String KEY_TRACE = "gov.trace";
    private static final String KEY_EVENTS_ENABLE = "gov.trace.events.enable";
    private static final String KEY_TAGS_ENABLE = "gov.trace.tags.enable";

    public static boolean isEventEnable(String type, String event) {
        if (TraceConfig.isTrue(KEY_TRACE_DEBUG)) {
            return true;
        }
        if (TraceConfig.isTrue(KEY_EVENTS_ENABLE)) {
            return true;
        }
        return TraceConfig.isEnable(false, type, "events", event);
    }

    private static final String getProperty(String key) {
        String v = SystemProperties.get((String)key);
        if (v == null) {
            return EnableConfig.getProperty(key);
        }
        return v;
    }

    private static boolean isTrue(String key) {
        return "true".equals(TraceConfig.getProperty(key));
    }

    public static boolean isTagEnable(String type, String tag) {
        if (TraceConfig.isTrue(KEY_TRACE_DEBUG)) {
            return true;
        }
        if (TraceConfig.isTrue(KEY_TAGS_ENABLE)) {
            return true;
        }
        return TraceConfig.isEnable(false, type, "tags", tag);
    }

    public static boolean isSpanEnable(String type, String spanName) {
        if ("true".equals(TraceConfig.getProperty(KEY_TRACE_DEBUG))) {
            return true;
        }
        return TraceConfig.isEnable(true, type, spanName);
    }

    public static boolean isTypeEnable(String type) {
        if (TraceConfig.isTrue(KEY_TRACE_DEBUG)) {
            return true;
        }
        return TraceConfig.isEnable(true, type);
    }

    public static boolean isTraceEnable() {
        return TraceConfig.isTrue(KEY_TRACE_DEBUG) || TraceConfig.isTrue(KEY_TRACE_ENABLE);
    }

    private static boolean isEnable(boolean defaultValue, String ... configKeys) {
        String type = System.getProperty("gov.trace.reporter.type", "sword");
        if (type.equals("sword")) {
            return TraceConfig.isSwordEnable(defaultValue, configKeys);
        }
        StringBuilder sb = new StringBuilder(32);
        sb.append(KEY_TRACE);
        for (String key : configKeys) {
            sb.append('.').append(key);
        }
        if (configKeys != null && configKeys.length > 0) {
            sb.append('.');
        }
        sb.append("enable");
        String v = TraceConfig.getProperty(sb.toString());
        if (v == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(v);
    }

    private static boolean isSwordEnable(boolean defaultValue, String ... configKeys) {
        String traceType = null;
        defaultValue = Boolean.getBoolean("trace.reporter.sword.vip.enable");
        StringBuilder sb = new StringBuilder(32);
        sb.append(KEY_TRACE);
        sb.append('.').append("sword");
        for (String key : configKeys) {
            sb.append('.').append(key);
        }
        if (configKeys != null && configKeys.length > 0) {
            sb.append('.');
            traceType = configKeys[0];
        }
        sb.append("enable");
        String v = TraceConfig.getProperty(sb.toString());
        if (v == null) {
            StringBuilder strBuil = new StringBuilder(32);
            strBuil.append(KEY_TRACE).append('.').append("sword").append('.').append(traceType).append(".*").append(".enable");
            v = TraceConfig.getProperty(strBuil.toString());
        }
        if (v == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(v);
    }
}

