/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.core;

import java.util.Random;
import java.util.concurrent.Callable;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.Sampler;
import kd.bos.trace.core.SpanContextHolder;
import kd.bos.trace.core.SpanNamer;
import kd.bos.trace.core.TraceKeys;
import kd.bos.trace.instrument.async.SpanContinuingTraceCallable;
import kd.bos.trace.instrument.async.SpanContinuingTraceRunnable;
import kd.bos.trace.log.SpanLogger;
import kd.bos.trace.reporter.apicall.APICallReporterProvider;
import kd.bos.trace.reporter.topology.TopologyReporterProvider;
import kd.bos.trace.util.SpanNameUtil;
import kd.bos.trace.util.TraceIdUtil;

public class DefaultTracer
implements InnerTracer {
    private static final InnerSpanReporter topologyReporter = TopologyReporterProvider.getInstance();
    private static final InnerSpanReporter apiCallReporter = APICallReporterProvider.getInstance();
    private static final int MAX_CHARS_IN_SPAN_NAME = 50;
    private final Sampler defaultSampler;
    private final SpanNamer spanNamer;
    private final SpanLogger spanLogger;
    private final InnerSpanReporter spanReporter;
    private final TraceKeys traceKeys;

    public DefaultTracer(Sampler defaultSampler, Random random, SpanNamer spanNamer, SpanLogger spanLogger, InnerSpanReporter spanReporter, TraceKeys traceKeys) {
        this(defaultSampler, random, spanNamer, spanLogger, spanReporter, false, traceKeys);
    }

    public DefaultTracer(Sampler defaultSampler, Random random, SpanNamer spanNamer, SpanLogger spanLogger, InnerSpanReporter spanReporter, boolean traceId128, TraceKeys traceKeys) {
        this.defaultSampler = defaultSampler;
        this.spanNamer = spanNamer;
        this.spanLogger = spanLogger;
        this.spanReporter = spanReporter;
        this.traceKeys = traceKeys != null ? traceKeys : new TraceKeys();
    }

    @Override
    public InnerSpan createSpan(String name, InnerSpan parent) {
        if (parent == null) {
            return this.createSpan(name);
        }
        return this.continueSpan(this.createChild(parent, name, false));
    }

    @Override
    public InnerSpan createSpan(String name, InnerSpan parent, boolean isCrossNode) {
        if (parent == null) {
            return this.createSpan(name, isCrossNode);
        }
        return this.continueSpan(this.createChild(parent, name, isCrossNode));
    }

    @Override
    public InnerSpan createSpan(String name) {
        return this.createSpan(name, this.defaultSampler);
    }

    @Override
    public long createTraceId() {
        return this.createId();
    }

    @Override
    public InnerSpan createSpan(String name, boolean isCrossNode) {
        return this.createSpan(name, this.defaultSampler, isCrossNode);
    }

    private long getTraceId() {
        long l = TraceIdUtil.getCurrentTraceId();
        return l != -1L ? l : this.createId();
    }

    @Override
    public InnerSpan createSpan(String name, Sampler sampler) {
        InnerSpan span;
        String shortenedName = SpanNameUtil.shorten(name);
        if (this.isTracing()) {
            span = this.createChild(this.getCurrentSpan(), shortenedName, false);
        } else {
            long traceId = this.getTraceId();
            span = InnerSpan.builder().name(shortenedName).traceId(traceId).spanId(traceId).isCrossNode(false).build();
            if (sampler == null) {
                sampler = this.defaultSampler;
            }
            span = this.sampledSpan(span, sampler);
            this.spanLogger.logStartedSpan(null, span);
        }
        return this.continueSpan(span);
    }

    @Override
    public InnerSpan createSpan(String name, Sampler sampler, boolean isCrossNode) {
        InnerSpan span;
        String shortenedName = SpanNameUtil.shorten(name);
        if (this.isTracing()) {
            span = this.createChild(this.getCurrentSpan(), shortenedName, isCrossNode);
        } else {
            long traceId = this.getTraceId();
            span = InnerSpan.builder().name(shortenedName).traceId(traceId).spanId(traceId).isCrossNode(isCrossNode).build();
            if (sampler == null) {
                sampler = this.defaultSampler;
            }
            span = this.sampledSpan(span, sampler);
            this.spanLogger.logStartedSpan(null, span);
        }
        return this.continueSpan(span);
    }

    private String shortenNameIfNecessary(String name) {
        int maxLength = name.length() > 50 ? 50 : name.length();
        return name.substring(0, maxLength);
    }

    @Override
    public InnerSpan detach(InnerSpan span) {
        if (span == null) {
            return null;
        }
        InnerSpan cur = SpanContextHolder.getCurrentSpan();
        if (span.equals(cur)) {
            SpanContextHolder.removeCurrentSpan();
        }
        return span.getSavedSpan();
    }

    @Override
    public InnerSpan close(InnerSpan span) {
        if (span == null) {
            return null;
        }
        InnerSpan cur = SpanContextHolder.getCurrentSpan();
        final InnerSpan savedSpan = span.getSavedSpan();
        if (span.equals(cur)) {
            span.stop();
            if (savedSpan != null && span.getParents().contains(savedSpan.getSpanId())) {
                this.spanReporter.report(span);
                this.spanLogger.logStoppedSpan(savedSpan, span);
            } else if (!span.isRemote()) {
                this.spanReporter.report(span);
                this.spanLogger.logStoppedSpan(null, span);
            }
            SpanContextHolder.close(new SpanContextHolder.SpanFunction(){

                @Override
                public void apply(InnerSpan span) {
                    DefaultTracer.this.spanLogger.logStoppedSpan(savedSpan, span);
                }
            });
        }
        topologyReporter.report(span);
        apiCallReporter.report(span);
        return savedSpan;
    }

    InnerSpan createChild(InnerSpan parent, String name, boolean isCrossNode) {
        String shortenedName = SpanNameUtil.shorten(name);
        long traceId = this.getTraceId();
        if (parent == null) {
            InnerSpan span = InnerSpan.builder().name(shortenedName).traceId(traceId).spanId(traceId).isCrossNode(isCrossNode).build();
            span = this.sampledSpan(span, this.defaultSampler);
            this.spanLogger.logStartedSpan(null, span);
            return span;
        }
        long id = this.createId();
        if (!this.isTracing()) {
            SpanContextHolder.push(parent, true);
        }
        InnerSpan span = InnerSpan.builder().name(shortenedName).traceId(parent.getTraceId()).parent(parent.getSpanId()).spanId(id).processId(parent.getProcessId()).savedSpan(parent).exportable(parent.isExportable()).baggage(parent.getBaggage()).isCrossNode(isCrossNode).build();
        this.spanLogger.logStartedSpan(parent, span);
        return span;
    }

    private InnerSpan sampledSpan(InnerSpan span, Sampler sampler) {
        if (!sampler.isSampled(span)) {
            return InnerSpan.builder().begin(span.getBegin()).traceId(span.getTraceId()).spanId(span.getSpanId()).name(span.getName()).exportable(false).build();
        }
        return span;
    }

    private long createId() {
        return TraceIdUtil.createId();
    }

    @Override
    public InnerSpan continueSpan(InnerSpan span) {
        if (span == null) {
            return null;
        }
        this.spanLogger.logContinuedSpan(span);
        InnerSpan newSpan = this.createContinuedSpan(span, SpanContextHolder.getCurrentSpan());
        SpanContextHolder.setCurrentSpan(newSpan);
        return newSpan;
    }

    private InnerSpan createContinuedSpan(InnerSpan span, InnerSpan saved) {
        if (saved == null && span.getSavedSpan() != null) {
            saved = span.getSavedSpan();
        }
        return new InnerSpan(span, saved);
    }

    @Override
    public InnerSpan getCurrentSpan() {
        return SpanContextHolder.getCurrentSpan();
    }

    @Override
    public boolean isTracing() {
        return SpanContextHolder.isTracing();
    }

    @Override
    public void addTag(String key, String value) {
        InnerSpan s = this.getCurrentSpan();
        if (s != null && s.isExportable()) {
            s.tag(key, value);
        }
    }

    @Override
    public <V> Callable<V> wrap(Callable<V> callable) {
        if (this.isTracing()) {
            return new SpanContinuingTraceCallable<V>((InnerTracer)this, this.traceKeys, this.spanNamer, callable);
        }
        return callable;
    }

    @Override
    public Runnable wrap(Runnable runnable) {
        if (this.isTracing()) {
            return new SpanContinuingTraceRunnable((InnerTracer)this, this.traceKeys, this.spanNamer, runnable);
        }
        return runnable;
    }
}

