/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.core;

import kd.bos.trace.core.InnerSpan;

class SpanContextHolder {
    private static final ThreadLocal<SpanContext> CURRENT_SPAN = new ThreadLocal();

    SpanContextHolder() {
    }

    static InnerSpan getCurrentSpan() {
        return SpanContextHolder.isTracing() ? CURRENT_SPAN.get().span : null;
    }

    static void setCurrentSpan(InnerSpan span) {
        SpanContextHolder.push(span, false);
    }

    static void removeCurrentSpan() {
        CURRENT_SPAN.remove();
    }

    static boolean isTracing() {
        return CURRENT_SPAN.get() != null;
    }

    static void close(SpanFunction spanFunction) {
        SpanContext current = CURRENT_SPAN.get();
        CURRENT_SPAN.remove();
        while (current != null) {
            spanFunction.apply((current = current.parent) != null ? current.span : null);
            if (current == null || current.autoClose) continue;
            CURRENT_SPAN.set(current);
            current = null;
        }
    }

    static void close() {
        SpanContextHolder.close(new NoOpFunction());
    }

    static void push(InnerSpan span, boolean autoClose) {
        if (SpanContextHolder.isCurrent(span)) {
            return;
        }
        CURRENT_SPAN.set(new SpanContext(span, autoClose));
    }

    private static boolean isCurrent(InnerSpan span) {
        if (span == null || CURRENT_SPAN.get() == null) {
            return false;
        }
        return span.equals(CURRENT_SPAN.get().span);
    }

    private static class NoOpFunction
    implements SpanFunction {
        private NoOpFunction() {
        }

        @Override
        public void apply(InnerSpan span) {
        }
    }

    @FunctionalInterface
    static interface SpanFunction {
        public void apply(InnerSpan var1);
    }

    private static class SpanContext {
        private InnerSpan span;
        private boolean autoClose;
        private SpanContext parent;

        public SpanContext(InnerSpan span, boolean autoClose) {
            this.span = span;
            this.autoClose = autoClose;
            this.parent = (SpanContext)CURRENT_SPAN.get();
        }
    }
}

