/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import kd.bos.trace.Tracer;
import kd.bos.trace.instrument.AOP;

public abstract class TraceAOP
implements AOP {
    protected TraceInfo getTraceInfo(Method method, Object[] args) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (this.exclude(method.getName())) {
            return null;
        }
        return this.getTraceInfoImpl(method, args);
    }

    protected boolean exclude(String name) {
        return false;
    }

    protected abstract TraceInfo getTraceInfoImpl(Method var1, Object[] var2);

    @Override
    public void before(Object proxy, Method method, Object[] args) {
        if (Tracer.isTracing()) {
            TraceInfo info = this.getTraceInfo(method, args);
            this.addTag(info);
        }
    }

    private void addTag(TraceInfo info) {
        if (info != null) {
            Tracer.create(info.type, info.spanName);
            if (info.tags != null) {
                for (Map.Entry entry : info.tags.entrySet()) {
                    Tracer.addTag((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    @Override
    public void after(Object proxy, Method method, Object[] args, Object result) {
        TraceInfo info;
        if (Tracer.isTracing() && (info = this.getTraceInfo(method, args)) != null) {
            Tracer.close();
        }
    }

    protected static class TraceInfo {
        private String spanName;
        private String type;
        private HashMap<String, String> tags;

        protected TraceInfo() {
        }

        public void addTag(String key, String value) {
            if (this.tags == null) {
                this.tags = new HashMap();
            }
            this.tags.put(key, value);
        }

        public String getSpanName() {
            return this.spanName;
        }

        public void setSpanName(String spanName) {
            this.spanName = spanName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public HashMap<String, String> getTags() {
            return this.tags;
        }

        public void setTags(HashMap<String, String> tags) {
            this.tags = tags;
        }
    }
}

