/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kd.bos.trace.instrument.AOP;
import kd.bos.trace.instrument.jedis.JedisAOP;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class TraceProxy {
    private static Logger logger = LoggerFactory.getLogger(TraceProxy.class);
    private static Map<Class<?>, AOP> handlers = new HashMap();

    private static AOP getAOP(Class<?> clz) {
        return handlers.get(clz);
    }

    public static void registerAOP(Class<?> clz, AOP aop) {
        handlers.put(clz, aop);
    }

    public static void registerAOP(String keyClassName, String aopClassName) {
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            Class<?> aopClass = Class.forName(aopClassName);
            TraceProxy.registerAOP(keyClass, (AOP)aopClass.newInstance());
        }
        catch (Exception t) {
            logger.warn("TraceProxy.registerAOP error", (Throwable)t);
        }
    }

    public static <T> T createProxy(T object, Class<?> clazz) {
        return TraceProxy.createProxy(object, clazz, TraceProxy.getAOP(clazz));
    }

    public static <T> T createProxy(final T object, Class<?> clazz, final AOP aop) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (aop == null) {
            throw new NullPointerException("Aop is null for " + object.getClass().getName());
        }
        MethodInterceptor interceptor = new MethodInterceptor(){

            public Object intercept(Object CGLIB$OJB, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                try {
                    aop.before(object, method, args);
                }
                catch (Exception t) {
                    logger.warn("TraceProxy.createProxy error", (Throwable)t);
                }
                Object result = null;
                try {
                    Object object2 = result = method.invoke(object, args);
                    return object2;
                }
                catch (Exception t) {
                    result = t;
                    throw t;
                }
                finally {
                    try {
                        aop.after(object, method, args, result);
                    }
                    catch (Exception t) {
                        logger.warn("TraceProxy.createProxy error", (Throwable)t);
                    }
                }
            }
        };
        Enhancer enhancer = new Enhancer();
        if (clazz.isInterface()) {
            enhancer.setInterfaces(new Class[]{clazz});
        } else {
            enhancer.setSuperclass(clazz);
        }
        enhancer.setCallback((Callback)interceptor);
        return (T)enhancer.create();
    }

    static {
        TraceProxy.registerAOP(Jedis.class, new JedisAOP());
        TraceProxy.registerAOP(JedisCluster.class, new JedisAOP());
    }
}

