/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.async;

import java.util.concurrent.Callable;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.SpanNamer;
import kd.bos.trace.core.TraceCallable;
import kd.bos.trace.core.TraceKeys;

public class LocalComponentTraceCallable<V>
extends TraceCallable<V> {
    protected static final String ASYNC_COMPONENT = "async";
    private final TraceKeys traceKeys;

    public LocalComponentTraceCallable(InnerTracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Callable<V> delegate) {
        super(tracer, spanNamer, delegate);
        this.traceKeys = traceKeys;
    }

    public LocalComponentTraceCallable(InnerTracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, String name, Callable<V> delegate) {
        super(tracer, spanNamer, delegate, name);
        this.traceKeys = traceKeys;
    }

    @Override
    public V call() {
        InnerSpan span = this.startSpan();
        try {
            Object v = this.getDelegate().call();
            return v;
        }
        catch (Exception e) {
            throw new IllegalStateException("apm call exception,errMessage:", e);
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected InnerSpan startSpan() {
        InnerSpan span = this.getTracer().createSpan(this.getSpanName(), this.getParent());
        this.getTracer().addTag("lc", ASYNC_COMPONENT);
        this.getTracer().addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getThreadNameKey(), Thread.currentThread().getName());
        return span;
    }
}

