/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.async;

import java.util.concurrent.Callable;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.SpanNamer;
import kd.bos.trace.core.TraceCallable;
import kd.bos.trace.core.TraceKeys;
import kd.bos.trace.instrument.async.LocalComponentTraceCallable;

public class SpanContinuingTraceCallable<V>
extends TraceCallable<V> {
    private final LocalComponentTraceCallable<V> traceCallable;

    public SpanContinuingTraceCallable(InnerTracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Callable<V> delegate) {
        super(tracer, spanNamer, delegate);
        this.traceCallable = new LocalComponentTraceCallable<V>(tracer, traceKeys, spanNamer, delegate);
    }

    public SpanContinuingTraceCallable(InnerTracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, String name, Callable<V> delegate) {
        super(tracer, spanNamer, delegate, name);
        this.traceCallable = new LocalComponentTraceCallable<V>(tracer, traceKeys, spanNamer, name, delegate);
    }

    @Override
    public V call() {
        InnerSpan span = this.startSpan();
        try {
            Object v = this.getDelegate().call();
            return v;
        }
        catch (Exception e) {
            throw new IllegalStateException("apm call exception,errMessage:", e);
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected InnerSpan startSpan() {
        InnerSpan span = this.getParent();
        if (span == null) {
            return this.traceCallable.startSpan();
        }
        return this.continueSpan(span);
    }

    @Override
    protected void close(InnerSpan span) {
        if (this.getParent() == null) {
            super.close(span);
        } else {
            super.detachSpan(span);
        }
    }
}

