/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.SpanNamer;
import kd.bos.trace.core.TraceKeys;
import kd.bos.trace.instrument.async.LocalComponentTraceRunnable;
import kd.bos.trace.instrument.async.SpanContinuingTraceCallable;
import kd.bos.trace.instrument.async.SpanContinuingTraceRunnable;

public class TraceableExecutorService
implements ExecutorService {
    private final String spanName;
    private ExecutorService delegate_field;
    private InnerTracer innerTracer;
    private TraceKeys fTraceKeys;
    private SpanNamer fSpanNamer;

    public TraceableExecutorService(ExecutorService delegate, InnerTracer innerTracer, TraceKeys traceKeys, SpanNamer spanNamer) {
        this(delegate, innerTracer, traceKeys, spanNamer, null);
    }

    public TraceableExecutorService(ExecutorService delegate, InnerTracer innerTracer, TraceKeys traceKeys, SpanNamer spanNamer, String spanName) {
        this.delegate_field = delegate;
        this.innerTracer = innerTracer;
        this.spanName = spanName;
        this.fTraceKeys = traceKeys;
        this.fSpanNamer = spanNamer;
    }

    @Override
    public void execute(Runnable command) {
        LocalComponentTraceRunnable r = new LocalComponentTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), command, this.spanName);
        this.delegate_field.execute(r);
    }

    @Override
    public void shutdown() {
        this.delegate_field.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate_field.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate_field.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate_field.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate_field.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        SpanContinuingTraceCallable<T> c = new SpanContinuingTraceCallable<T>(this.tracer(), this.traceKeys(), this.spanNamer(), this.spanName, task);
        return this.delegate_field.submit(c);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        SpanContinuingTraceRunnable r = new SpanContinuingTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), task, this.spanName);
        return this.delegate_field.submit(r, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        LocalComponentTraceRunnable r = new LocalComponentTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), task, this.spanName);
        return this.delegate_field.submit(r);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate_field.invokeAll(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate_field.invokeAll(this.wrapCallableCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate_field.invokeAny(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate_field.invokeAny(this.wrapCallableCollection(tasks), timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<SpanContinuingTraceCallable<T>> ts = new ArrayList<SpanContinuingTraceCallable<T>>();
        for (Callable<T> task : tasks) {
            if (task instanceof SpanContinuingTraceCallable) continue;
            ts.add(new SpanContinuingTraceCallable<T>(this.tracer(), this.traceKeys(), this.spanNamer(), this.spanName, task));
        }
        return ts;
    }

    InnerTracer tracer() {
        return this.innerTracer;
    }

    TraceKeys traceKeys() {
        return this.fTraceKeys;
    }

    SpanNamer spanNamer() {
        return this.fSpanNamer;
    }

    ExecutorService delegate() {
        return this.delegate_field;
    }
}

