/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.jdbc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.ksql.DbType;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.metric.Gauger;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;
import kd.bos.slowlog.SlowLogger;
import kd.bos.thread.ShardingStats;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.trace.tracer.SlowConfig;
import kd.bos.trace.tracer.TraceSpanImpl;
import kd.bos.util.JmxUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.bos.util.hint.SQLHintUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTrace {
    private static final Pattern PATTERN_DB_URL = Pattern.compile("([@|/])([\\w-]{1,63}(\\.)?){1,12}:(\\d+)");
    private static final Map<String, String> urlMap = new ConcurrentHashMap<String, String>(8);
    private static final Logger logger = LoggerFactory.getLogger(JdbcTrace.class);
    private static final Timer timer = MetricSystem.timer("kd.metrics.sql.execute");
    private static final String contextKey = "jdbc.timer.context";
    private static final Meter second1 = MetricSystem.meter("kd.metrics.sql.execute.slow1second");
    private static final Meter second5 = MetricSystem.meter("kd.metrics.sql.execute.slow5second");
    private static final Meter second10 = MetricSystem.meter("kd.metrics.sql.execute.slow10second");
    private static final Meter second30 = MetricSystem.meter("kd.metrics.sql.execute.slow30second");
    private static final Meter second60 = MetricSystem.meter("kd.metrics.sql.execute.slow60second");
    private static final ThreadLocal<Object[]> thPreviousSQL = ThreadLocals.create();
    private static final Class<?> kdconnectionCls;
    private static final DateTimeFormatter dateTimeFormatter;

    public static void executeBefore(String sql, String method) {
        TimeoutHandleFactory.get().handleTimeout();
        TraceSpan traceSpan = Tracer.create("jdbc", method, true);
        ShardingStats shardingSql = ShardingStats.get();
        if (shardingSql != null) {
            traceSpan.addTag("originalSQL", shardingSql.getOriginalSQL(), false);
            traceSpan.addTag("shardingCount", shardingSql.getShardingCount() + "", false);
        }
        traceSpan.addTag("sql", SQLHintUtils.getSQLHints() + sql, false);
        MemSpanTrace span = MemSpanTrace.create("jdbc", method);
        if (shardingSql != null) {
            span.addTag("originalSQL", shardingSql.getOriginalSQL());
            span.addTag("shardingCount", shardingSql.getShardingCount() + "");
        }
        span.addTag("sql", SQLHintUtils.getSQLHints() + sql);
        Timer.Context context = timer.time();
        ThreadTruck.put((Object)contextKey, (Object)context);
    }

    public static void executeAfter(String sql, Throwable error, Connection con) {
        MemSpanTrace span = MemSpanTrace.getCurrent();
        if (span != null) {
            span.close();
        }
        try {
            Timer.Context context;
            TraceSpanImpl traceSpan;
            KDConnection kdConnection = con instanceof KDConnection ? (KDConnection)con : (KDConnection)con.unwrap(kdconnectionCls);
            if (sql != null) {
                JdbcTrace.outputSlowLogger((Connection)kdConnection, sql);
            }
            JdbcTrace.setComponentTag((Connection)kdConnection);
            if (error != null) {
                Tracer.addTag("exception", error.getMessage(), true);
            }
            if ((traceSpan = TraceSpanImpl.getCurrent()) != null) {
                traceSpan.close();
            }
            if ((context = (Timer.Context)ThreadTruck.get((Object)contextKey)) != null) {
                long elapse = context.stop();
                if (elapse > 60000000000L) {
                    second60.mark();
                } else if (elapse > 30000000000L) {
                    second30.mark();
                } else if (elapse > 10000000000L) {
                    second10.mark();
                } else if (elapse > 5000000000L) {
                    second5.mark();
                } else if (elapse > 1000000000L) {
                    second1.mark();
                }
            }
        }
        catch (Exception e) {
            logger.warn("JdbcTrace.executeAfter error:" + e);
        }
    }

    private static void outputSlowLogger(Connection con, String sql) {
        String filterSqlKey;
        boolean force;
        boolean same = false;
        String preSQL = null;
        Object[] pres = thPreviousSQL.get();
        if (pres != null && con == pres[1] && sql.equals(preSQL = (String)pres[0])) {
            same = true;
        }
        if (!same) {
            thPreviousSQL.set(new Object[]{sql, con});
        }
        int cost = 0;
        TraceSpanImpl span = TraceSpanImpl.getCurrent();
        if (span != null) {
            cost = span.getCost();
        }
        boolean bl = force = cost > SlowConfig.getSlowTime("jdbc");
        if (!force && (filterSqlKey = System.getProperty("trace.sql.outstack.key")) != null && (filterSqlKey = filterSqlKey.trim().toLowerCase()).length() > 0 && sql.toLowerCase().indexOf(filterSqlKey) != -1) {
            force = true;
        }
        Tracer.addTag("sql", sql, force);
        JdbcTrace.outStack(force, sql, preSQL, cost, same);
    }

    private static void outStack(boolean force, String sql, String preSQL, int cost, boolean same) {
        if (force) {
            StringWriter stack = new StringWriter();
            new Exception("Slow SQL trace").printStackTrace(new PrintWriter(stack));
            int slqMaxLength = Integer.parseInt(System.getProperty("trace.sql.slowlogger.max_length", "4096"));
            if (sql.length() > slqMaxLength) {
                sql = sql.substring(0, slqMaxLength - 3) + "...";
            }
            StringBuilder builder = new StringBuilder("SlowLogger-JDBC: sql cost ");
            builder.append(cost).append("ms,time is:").append(dateTimeFormatter.format(LocalDateTime.now())).append(",\r\nSQL: ").append(sql);
            if (!same) {
                builder.append("\r\nPreviousSQL: ").append(preSQL == null ? "NONE" : preSQL);
            }
            builder.append("\r\n").append(stack);
            SlowLogger.log(builder.toString(), "SlowLogger", cost);
            SlowLogger.count("JDBC");
        }
    }

    private static void setComponentTag(Connection con) {
        try {
            if (GovernConfigs.getTopologyEnable()) {
                KDConnection kdConnection = (KDConnection)con;
                String dbType = DbType.getName((int)kdConnection.getDbType());
                String ipAndPort = JdbcTrace.getIpFromUrl(kdConnection.traceInfo().originalUrl);
                TopologyTagInject.setCompentTag(Tracer.getCurrentSpan().getInnerSpan(), ipAndPort, dbType, "db");
            }
        }
        catch (Exception e) {
            logger.warn("JdbcTrace.setComponentTag error:" + e, (Throwable)e);
        }
    }

    private static String getIpFromUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String parseUrl = urlMap.get(url);
        if (null != parseUrl) {
            return parseUrl;
        }
        Matcher m = PATTERN_DB_URL.matcher(url);
        if (m.find()) {
            parseUrl = m.group().replace("@", "").replace("/", "");
            urlMap.put(url, parseUrl);
            return parseUrl;
        }
        urlMap.put(url, url);
        return url;
    }

    static {
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        MetricSystem.gauge("kd.metrics.sql.execute.mean", () -> {
            Gauger<Object> metricsObj = new Gauger<Object>();
            metricsObj.setValueSupplier(() -> {
                Object mean = JmxUtils.getAtt((String)"kd.metrics:name=kd.metrics.sql.execute,type=timers", (String)"Mean");
                return mean == null ? Integer.valueOf(0) : mean;
            });
            return metricsObj;
        });
        MetricSystem.gauge("kd.metrics.sql.execute.max", () -> {
            Gauger<Object> metricsObj = new Gauger<Object>();
            metricsObj.setValueSupplier(() -> {
                Object max = JmxUtils.getAtt((String)"kd.metrics:name=kd.metrics.sql.execute,type=timers", (String)"Max");
                return max == null ? Integer.valueOf(0) : max;
            });
            return metricsObj;
        });
        try {
            kdconnectionCls = Class.forName("kd.bos.ksql.shell.KDConnection");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

