/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.hint.SQLHintUtils;

final class SQLTraceId {
    private static final String dialect_prefix = "/*dialect*/";
    private static final int dialectPrefixLength = "/*dialect*/".length();
    private static final Pattern tracePattern = Pattern.compile("[a-zA-Z0-9]{1,16}");
    private static final boolean appendTraceId = Boolean.getBoolean("db.sql.withTraceId");

    SQLTraceId() {
    }

    static String wrapWithTraceId(String sql) {
        String traceId;
        ArrayList<String> hints = new ArrayList<String>(2);
        String wrapQingHint = SQLHintUtils.getWrapSQLHints();
        hints.add(wrapQingHint);
        if (SQLTraceId.isAppendTraceId() && (traceId = SQLTraceId.getTraceId()) != null && !traceId.isEmpty()) {
            hints.add("/*+" + traceId + "*/");
            if (!tracePattern.matcher(traceId).matches()) {
                throw new IllegalArgumentException("uncorrect traceId: " + traceId);
            }
        }
        return SQLTraceId.wrapWithHints(sql, hints);
    }

    static boolean isAppendTraceId() {
        return appendTraceId;
    }

    static String wrapWithHints(String sql, List<String> hints) {
        if (hints == null) {
            return sql;
        }
        if ((hints = hints.stream().filter(h -> Objects.nonNull(h) && !h.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            return sql;
        }
        boolean isDialect = false;
        if ((sql = sql.trim()).startsWith(dialect_prefix)) {
            isDialect = true;
            sql = sql.substring(dialectPrefixLength);
            while (sql.startsWith(dialect_prefix)) {
                sql = sql.substring(dialectPrefixLength);
            }
        }
        String dialectPrefix = isDialect ? dialect_prefix : "";
        return dialectPrefix + String.join((CharSequence)"", hints) + sql;
    }

    static String getTraceId() {
        Map rcinfo = (Map)ThreadTruck.get((Object)"rcinfo");
        if (rcinfo == null) {
            return null;
        }
        return (String)rcinfo.get("traceId");
    }
}

