/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.instrument.web;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.slowlog.SlowLogger;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.trace.tracer.SlowConfig;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.MaskUtil;
import kd.bos.util.StringUtils;

public class TraceFilter
implements Filter {
    public static final String CTLRES = "/kdctlres/";
    private String KERPSESSIONID_KEY = "KERPSESSIONID";
    private boolean enable = true;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String KEY_LOGQUERYSTRING_ENABLE = "SlowLogger.web.queryString.enable";
    private static final String KEY_LOGPARAMS_ENABLE = "SlowLogger.web.params.enable";

    public static boolean isDownloadPlugin(HttpServletRequest request, String path) {
        String context = request.getContextPath();
        boolean isNewDownload = false;
        if (path.startsWith(CTLRES)) {
            isNewDownload = true;
        }
        return isNewDownload;
    }

    public void destroy() {
    }

    private String createTraceId(HttpServletRequest req) {
        String clientTraceId = req.getHeader("traceId");
        boolean useClientTraceId = true;
        if (!StringUtils.isEmpty((String)clientTraceId)) {
            try {
                Long.parseLong(clientTraceId.trim(), 16);
            }
            catch (Exception ex) {
                useClientTraceId = false;
            }
        } else {
            useClientTraceId = false;
        }
        if (useClientTraceId) {
            TraceIdUtil.setCurrentTraceId(clientTraceId);
            return clientTraceId;
        }
        long id = TraceIdUtil.createTraceId();
        String traceId = TraceIdUtil.idToHex(id);
        SetThreadName.setTraceId((String)traceId);
        return traceId;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String servletPath = ((HttpServletRequest)request).getServletPath();
        boolean isNeedTrace = TraceFilter.isDownloadPlugin((HttpServletRequest)request, servletPath);
        if (isNeedTrace) {
            this.generateTraceId(request, response, chain);
        } else if (!this.enable || servletPath.endsWith(".js") || servletPath.endsWith(".css") || servletPath.endsWith(".map") || servletPath.endsWith(".jpg") || servletPath.endsWith(".jpeg") || servletPath.endsWith(".gif") || servletPath.endsWith(".bmp") || servletPath.endsWith(".png") || servletPath.endsWith(".woff") || servletPath.endsWith(".woff2")) {
            chain.doFilter(request, response);
        } else {
            this.generateTraceId(request, response, chain);
        }
    }

    private boolean isSlowLoggerQueryStringEnable() {
        String str = System.getProperty(KEY_LOGQUERYSTRING_ENABLE);
        if (str != null) {
            return "true".equalsIgnoreCase(str);
        }
        return true;
    }

    private boolean isSlowLoggerParamsEnable() {
        String str = System.getProperty(KEY_LOGPARAMS_ENABLE);
        if (str != null) {
            return "true".equalsIgnoreCase(str);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTraceId(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        int cost;
        boolean force;
        Object rcinfo;
        TraceSpan span;
        HttpServletRequest req = (HttpServletRequest)request;
        String spanName = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        String traceId = this.createTraceId(req);
        HttpServletResponse res = (HttpServletResponse)response;
        res.addHeader("traceId", traceId);
        if (Boolean.TRUE.toString().equals(ThreadTruck.get((Object)"isMserviceRequset")) && !Boolean.TRUE.toString().equals(req.getHeader("isTianshu"))) {
            span = Tracer.create("VirtualMserviceRequst", spanName, true);
            TraceSpan traceSpan = Tracer.getCurrentSpan();
            if (traceSpan != null) {
                String destAppId = null;
                destAppId = destAppId != null ? destAppId : "userClientAppId";
                TopologyTagInject.setWebTag(traceSpan.getInnerSpan(), TopologyTagInject.getClient("virtual-mservice"), destAppId);
            }
        } else {
            span = Tracer.create("WebRequest", spanName, true);
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            int cost2;
            boolean force2;
            Object rcinfo2;
            String appId = request.getParameter("appId");
            if (StringUtils.isNotEmpty((String)appId)) {
                span.addTag("appId", appId, true);
            }
            if ((rcinfo2 = ThreadTruck.get((Object)"rcinfo")) instanceof Map) {
                Map rcInfoMap = (Map)rcinfo2;
                span.addTag("userName", (String)rcInfoMap.get("userName"), true);
            }
            boolean bl = force2 = (cost2 = span.getCost()) > SlowConfig.getSlowTime("WebRequest");
            if (queryString != null) {
                span.addTag("queryString", queryString, force2);
            }
            if (req.getCookies() != null) {
                span.addTag("cookies", this.getCookies(req), force2);
            }
            String params = this.getParams(req);
            queryString = TraceFilter.maskQueryString(queryString);
            if (params != null) {
                span.addTag("parameter", params, force2);
            }
            span.close();
            if (force2) {
                String statics;
                String msg = "SlowLogger-WEB: web request cost " + cost2 + "ms,time is:" + dateTimeFormatter.format(LocalDateTime.now()) + ",traceId is:" + traceId;
                if (queryString != null && this.isSlowLoggerQueryStringEnable()) {
                    msg = msg + "\r\n the queryString is:\r\n    " + queryString;
                }
                if (params != null && this.isSlowLoggerParamsEnable()) {
                    msg = msg + "\r\n the params is:\r\n    " + params;
                }
                if (StringUtils.isNotEmpty((String)(statics = TraceStatistics.getThreadTraceStatistic(Thread.currentThread())))) {
                    msg = msg + "\r\n the statics is:\r\n" + statics.replaceAll("&nbsp;", " ").replaceAll("<br>", "\n");
                }
                SlowLogger.log(msg, "SlowLogger", cost2);
                SlowLogger.count("WEB");
            }
            throw throwable;
        }
        String appId = request.getParameter("appId");
        if (StringUtils.isNotEmpty((String)appId)) {
            span.addTag("appId", appId, true);
        }
        if ((rcinfo = ThreadTruck.get((Object)"rcinfo")) instanceof Map) {
            Map rcInfoMap = (Map)rcinfo;
            span.addTag("userName", (String)rcInfoMap.get("userName"), true);
        }
        boolean bl = force = (cost = span.getCost()) > SlowConfig.getSlowTime("WebRequest");
        if (queryString != null) {
            span.addTag("queryString", queryString, force);
        }
        if (req.getCookies() != null) {
            span.addTag("cookies", this.getCookies(req), force);
        }
        String params = this.getParams(req);
        queryString = TraceFilter.maskQueryString(queryString);
        if (params != null) {
            span.addTag("parameter", params, force);
        }
        span.close();
        if (force) {
            String statics;
            String msg = "SlowLogger-WEB: web request cost " + cost + "ms,time is:" + dateTimeFormatter.format(LocalDateTime.now()) + ",traceId is:" + traceId;
            if (queryString != null && this.isSlowLoggerQueryStringEnable()) {
                msg = msg + "\r\n the queryString is:\r\n    " + queryString;
            }
            if (params != null && this.isSlowLoggerParamsEnable()) {
                msg = msg + "\r\n the params is:\r\n    " + params;
            }
            if (StringUtils.isNotEmpty((String)(statics = TraceStatistics.getThreadTraceStatistic(Thread.currentThread())))) {
                msg = msg + "\r\n the statics is:\r\n" + statics.replaceAll("&nbsp;", " ").replaceAll("<br>", "\n");
            }
            SlowLogger.log(msg, "SlowLogger", cost);
            SlowLogger.count("WEB");
        }
    }

    private String[] getSessionIds(HttpServletRequest req) {
        if (req.getCookies() == null || req.getCookies().length == 0) {
            return new String[]{null, null};
        }
        String KERPSESSIONID = null;
        String JSessionId = null;
        for (Cookie c : req.getCookies()) {
            if (c.getName().equals(this.KERPSESSIONID_KEY)) {
                KERPSESSIONID = c.getValue();
                continue;
            }
            if (!c.getName().equals("JSESSIONID")) continue;
            JSessionId = c.getValue();
        }
        return new String[]{KERPSESSIONID, JSessionId};
    }

    private String getCookies(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cookies.length; ++i) {
            Cookie c = cookies[i];
            if (i > 0) {
                sb.append(';');
            }
            sb.append(c.getName()).append('=').append(c.getValue());
        }
        return sb.toString();
    }

    private String getParams(HttpServletRequest req) {
        Map<String, String[]> params = req.getParameterMap();
        if (params == null || params.size() == 0) {
            return null;
        }
        if (ConfigurationUtil.getBoolean((String)"SlowLogger.params.mask.enable", (Boolean)true).booleanValue()) {
            try {
                params = TraceFilter.maskParams(params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            map.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue()[0]);
        }
        return map.toString();
    }

    private static String maskQueryString(String queryString) {
        if (ConfigurationUtil.getBoolean((String)"SlowLogger.params.mask.enable", (Boolean)true).booleanValue()) {
            int reserveLength = ConfigurationUtil.getInteger((String)"SlowLogger.params.mask.reserve", (Integer)2);
            if (queryString == null || queryString.isEmpty()) {
                return queryString;
            }
            StringBuilder sb = new StringBuilder();
            StringBuilder temp = new StringBuilder();
            for (char c : queryString.toCharArray()) {
                if (TraceFilter.finded(c)) {
                    sb.append(MaskUtil.maskString((String)temp.toString(), (int)reserveLength)).append(c);
                    temp = new StringBuilder();
                    continue;
                }
                temp.append(c);
            }
            if (temp.length() > 0) {
                sb.append(MaskUtil.maskString((String)temp.toString(), (int)reserveLength));
            }
            return sb.toString();
        }
        return queryString;
    }

    private static boolean finded(char c) {
        char[] sp;
        for (char c1 : sp = new char[]{'?', '&', '='}) {
            if (c1 != c) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String[]> maskParams(Map<String, String[]> params) {
        int reserveLength = ConfigurationUtil.getInteger((String)"SlowLogger.params.mask.reserve", (Integer)2);
        HashMap<String, String[]> map = new HashMap<String, String[]>(params.size());
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String[] value = entry.getValue();
            String maskedKey = TraceFilter.maskKey(MaskUtil.maskString((String)entry.getKey(), (int)reserveLength), map);
            String maskedValue = value[0] == null ? null : MaskUtil.maskJsonString((String)value[0], (int)reserveLength);
            map.put(maskedKey, new String[]{maskedValue});
        }
        return map;
    }

    private static String maskKey(String key, Map<String, String[]> map) {
        String maskedKey = key;
        if (map.get(key) != null) {
            maskedKey = TraceFilter.maskKey(key + "*", map);
        }
        return maskedKey;
    }

    public void init(FilterConfig config) {
        String s = config.getInitParameter("enable");
        if (s != null) {
            this.enable = Boolean.parseBoolean(s);
        }
        if ((s = config.getInitParameter("KERPSESSIONID_KEY")) != null) {
            this.KERPSESSIONID_KEY = s;
        }
    }
}

