/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.log;

import java.util.regex.Pattern;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.log.SpanLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4jSpanLogger
implements SpanLogger {
    private final Logger logger;
    private final Pattern nameSkipPattern;

    public Slf4jSpanLogger(String nameSkipPattern) {
        this.nameSkipPattern = Pattern.compile(nameSkipPattern);
        this.logger = LoggerFactory.getLogger(Slf4jSpanLogger.class);
    }

    Slf4jSpanLogger(String nameSkipPattern, Logger log) {
        this.nameSkipPattern = Pattern.compile(nameSkipPattern);
        this.logger = log;
    }

    @Override
    public void logStartedSpan(InnerSpan parent, InnerSpan span) {
        MDC.put((String)"X-B3-SpanId", (String)InnerSpan.idToHex(span.getSpanId()));
        MDC.put((String)"X-Span-Export", (String)String.valueOf(span.isExportable()));
        MDC.put((String)"X-B3-TraceId", (String)span.traceIdString());
        this.log("Starting span: {}", span);
        if (parent != null) {
            this.log("With parent: {}", parent);
            MDC.put((String)"X-B3-ParentSpanId", (String)InnerSpan.idToHex(parent.getSpanId()));
        }
    }

    @Override
    public void logContinuedSpan(InnerSpan span) {
        MDC.put((String)"X-B3-SpanId", (String)InnerSpan.idToHex(span.getSpanId()));
        MDC.put((String)"X-B3-TraceId", (String)span.traceIdString());
        MDC.put((String)"X-Span-Export", (String)String.valueOf(span.isExportable()));
        this.setParentIdIfPresent(span);
        this.log("Continued span: {}", span);
    }

    private void setParentIdIfPresent(InnerSpan span) {
        if (!span.getParents().isEmpty()) {
            MDC.put((String)"X-B3-ParentSpanId", (String)InnerSpan.idToHex(span.getParents().get(0)));
        }
    }

    @Override
    public void logStoppedSpan(InnerSpan parent, InnerSpan span) {
        this.log("Stopped span: {}", span);
        if (span != null && parent != null) {
            this.log("With parent: {}", parent);
            MDC.put((String)"X-B3-SpanId", (String)InnerSpan.idToHex(parent.getSpanId()));
            MDC.put((String)"X-Span-Export", (String)String.valueOf(parent.isExportable()));
            this.setParentIdIfPresent(parent);
        } else {
            MDC.remove((String)"X-B3-SpanId");
            MDC.remove((String)"X-Span-Export");
            MDC.remove((String)"X-B3-TraceId");
            MDC.remove((String)"X-B3-ParentSpanId");
        }
    }

    private void log(String text, InnerSpan span) {
        if (span != null && this.nameSkipPattern.matcher(span.getName()).matches()) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(text, (Object)span);
        }
    }
}

