/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.apicall;

import kd.bos.govern.GovernConfigs;
import kd.bos.instance.Instance;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.tracer.TraceSpanImpl;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;

public class APICallTagInject {
    public static void setMserviceTag(InnerSpan newSpan, String srcIp, String destIp, String type, String serviceName, String methodName, String appId, String destInstance) {
        if (!GovernConfigs.getApicallEnable()) {
            return;
        }
        TraceSpanImpl traceSpan = TraceSpanImpl.getCurrent();
        if (newSpan == null) {
            if (traceSpan == null) {
                return;
            }
            newSpan = APICallTagInject.creatSpan(traceSpan, "MserviceApiCall");
            traceSpan.setGovernSpan(newSpan);
        }
        newSpan.tag("APICall.type", type);
        newSpan.tag("APICall.traceId", TraceIdUtil.getCurrentTraceIdString());
        newSpan.tag("APICall.srcIp", srcIp);
        newSpan.tag("APICall.destIp", destIp);
        newSpan.tag("APICall.serviceName", serviceName);
        newSpan.tag("APICall.methodName", methodName);
        newSpan.tag("APICall.appId", appId);
        newSpan.tag("APICall.signature", serviceName + ":" + methodName);
        newSpan.tag("APICall.collectionTime", String.valueOf(System.currentTimeMillis()));
        String appName = newSpan.tags().get("consumer.appName");
        if (StringUtils.isNotEmpty((String)appName)) {
            newSpan.tag("APICall.appName", appName);
        } else {
            newSpan.tag("APICall.appName", Instance.getAppName());
        }
        newSpan.tag("APICall.instanceId", destInstance);
    }

    public static void setIp(InnerSpan newSpan, String srcIp, String destIp) {
        if (!GovernConfigs.getApicallEnable()) {
            return;
        }
        TraceSpanImpl traceSpan = TraceSpanImpl.getCurrent();
        if (newSpan == null) {
            if (traceSpan == null) {
                return;
            }
            newSpan = APICallTagInject.creatSpan(traceSpan, "IPApiCall");
            traceSpan.setGovernSpan(newSpan);
        }
        newSpan.tag("APICall.srcIp", srcIp);
        newSpan.tag("APICall.destIp", destIp);
    }

    public static void setHttpTag(InnerSpan newSpan, String srcIp, String destIp, String type, String signature, String appId) {
        if (!GovernConfigs.getApicallEnable()) {
            return;
        }
        TraceSpanImpl traceSpan = TraceSpanImpl.getCurrent();
        if (newSpan == null) {
            if (traceSpan == null) {
                return;
            }
            newSpan = APICallTagInject.creatSpan(traceSpan, "HttpApiCall");
            traceSpan.setGovernSpan(newSpan);
        }
        newSpan.tag("APICall.type", type);
        newSpan.tag("APICall.traceId", TraceIdUtil.getCurrentTraceIdString());
        newSpan.tag("APICall.appId", appId);
        newSpan.tag("APICall.srcIp", srcIp);
        newSpan.tag("APICall.destIp", destIp);
        newSpan.tag("APICall.signature", APICallTagInject.splitContextPath(signature));
        newSpan.tag("APICall.collectionTime", String.valueOf(System.currentTimeMillis()));
        newSpan.tag("APICall.appName", "gateway");
        newSpan.tag("APICall.instanceId", Instance.getInstanceId());
    }

    private static InnerSpan creatSpan(TraceSpanImpl traceSpan, String spanName) {
        InnerSpan innerSpan = traceSpan.getGovernSpan();
        if (innerSpan != null) {
            return innerSpan;
        }
        long traceId = TraceIdUtil.createId();
        return InnerSpan.builder().name(spanName).traceId(traceId).spanId(traceId).begin(traceSpan.getStartTime()).isCrossNode(false).build();
    }

    private static String splitContextPath(String signature) {
        String contextPath = SystemProperties.getWithEnv((String)"JETTY_CONTEXT", (String)"/ierp");
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (signature.startsWith(contextPath)) {
            signature = signature.replaceFirst(contextPath, "");
        }
        return signature;
    }
}

