/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin;

import kd.bos.trace.reporter.zipkin.EndpointLocator;
import kd.bos.trace.util.InetUtils;
import kd.bos.trace.util.InetUtilsProperties;
import kd.bos.util.WebPortUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Endpoint;

public class ConfiguredEndpointLocator
implements EndpointLocator {
    private static Logger logger = LoggerFactory.getLogger(ConfiguredEndpointLocator.class);
    private int ipv4;
    private int port = 0;
    private boolean inited = false;

    private synchronized void init() {
        if (this.inited) {
            return;
        }
        InetUtils utils = new InetUtils(new InetUtilsProperties());
        InetUtils.HostInfo info = utils.findFirstNonLoopbackHostInfo();
        this.ipv4 = info.getIpAddressAsInt();
        String s = WebPortUtil.getWebPort(null);
        if (s != null) {
            try {
                this.port = Integer.parseInt(s);
            }
            catch (Exception t) {
                logger.warn("ConfiguredEndpointLocator.init error:" + t);
            }
        } else {
            this.port = 20880;
        }
        this.inited = true;
    }

    @Override
    public Endpoint local() {
        if (!this.inited) {
            this.init();
        }
        String serviceName = System.getProperty("nodeName", "serviceName");
        return Endpoint.builder().serviceName(serviceName).ipv4(this.ipv4).port(this.port).build();
    }
}

