/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kd.bos.trace.metric.SpanMetricReporter;
import kd.bos.trace.reporter.zipkin.ReporterMetricsAdapter;
import kd.bos.trace.reporter.zipkin.ZipkinSpanReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Span;
import zipkin.reporter.AsyncReporter;
import zipkin.reporter.ReporterMetrics;
import zipkin.reporter.Sender;

public final class SenderSpanReporter
implements ZipkinSpanReporter,
Flushable,
Closeable {
    private static Logger logger = LoggerFactory.getLogger(SenderSpanReporter.class);
    private final Sender sender;
    private final AsyncReporter<Span> delegate;

    public SenderSpanReporter(Sender sender, int flushInterval, SpanMetricReporter spanMetricReporter) {
        this.sender = sender;
        this.delegate = AsyncReporter.builder((Sender)this.sender).queuedMaxSpans(1000).messageTimeout((long)flushInterval, TimeUnit.SECONDS).metrics((ReporterMetrics)new ReporterMetricsAdapter(spanMetricReporter)).build();
    }

    @Override
    public void report(Span span) {
        this.delegate.report((Object)span);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
        try {
            this.sender.close();
        }
        catch (IOException e) {
            logger.warn("SenderSpanReporter.close error:" + e);
        }
    }

    @Override
    public void report(Span[] span) {
        if (span.length == 1) {
            this.report(span[0]);
        } else {
            this.delegate.report((Object[])span);
        }
    }
}

