/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin;

import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.metric.NoOpSpanMetricReporter;
import kd.bos.trace.reporter.ZipkinInnerSpanReporter;
import kd.bos.trace.reporter.zipkin.ConfiguredEndpointLocator;
import kd.bos.trace.reporter.zipkin.SenderCreator;
import kd.bos.trace.reporter.zipkin.SenderSpanReporter;
import kd.bos.trace.reporter.zipkin.http.HttpSender;
import kd.bos.trace.reporter.zipkin.http.URLConnectionTemplate;
import kd.bos.trace.reporter.zipkin.kafka08.KafkaSender;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.reporter.Sender;

public class ZipkinFactory {
    private static Logger logger = LoggerFactory.getLogger(ZipkinFactory.class);

    private static Sender createHttpSender(String url) {
        URLConnectionTemplate template = new URLConnectionTemplate(url);
        HttpSender sender = new HttpSender(template);
        return sender;
    }

    private static Sender createKafkaSender(String url, String topic) {
        return KafkaSender.create(url, topic);
    }

    public static InnerSpanReporter createReporter(Sender sender) {
        int flushInterval = 1;
        NoOpSpanMetricReporter spanMetricReporter = new NoOpSpanMetricReporter();
        SenderSpanReporter reporter = new SenderSpanReporter(sender, flushInterval, spanMetricReporter);
        ConfiguredEndpointLocator endpointLocator = new ConfiguredEndpointLocator();
        ZipkinInnerSpanReporter l = new ZipkinInnerSpanReporter(reporter, endpointLocator);
        return l;
    }

    public static InnerSpanReporter createHttpReporter(String url) {
        return ZipkinFactory.createReporter(ZipkinFactory.createHttpSender(url));
    }

    public static InnerSpanReporter createKafkaReporter(String url, String topic) {
        return ZipkinFactory.createReporter(ZipkinFactory.createKafkaSender(url, topic));
    }

    public static InnerSpanReporter createReporter(String type) {
        String senderCreatorClassName = System.getProperty("gov.trace.reporter.type." + type);
        if (StringUtils.isEmpty((String)senderCreatorClassName)) {
            return null;
        }
        try {
            Class<?> senderClass = Class.forName(senderCreatorClassName);
            SenderCreator creator = (SenderCreator)senderClass.newInstance();
            return ZipkinFactory.createReporter(creator.create());
        }
        catch (ClassNotFoundException e) {
            logger.warn("ZipkinFactory.createReporter ClassNotFoundException:" + e);
        }
        catch (InstantiationException e) {
            logger.warn("ZipkinFactory.createReporter InstantiationException:" + e);
        }
        catch (IllegalAccessException e) {
            logger.warn("ZipkinFactory.createReporter IllegalAccessException:" + e);
        }
        return null;
    }
}

