/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import kd.bos.trace.reporter.zipkin.http.HttpTemplate;

public class URLConnectionTemplate
implements HttpTemplate {
    private URL url;

    public URLConnectionTemplate(String url) {
        try {
            this.url = new URL(url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("url illegal:" + url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(byte[] body, String mediaType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", mediaType);
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(body.length);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(body);
        }
    }
}

