/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin.kafka08;

import java.util.Map;
import kd.bos.trace.reporter.zipkin.kafka08.KafkaSender;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Encoding;

final class AutoValue_KafkaSender
extends KafkaSender {
    private final Encoding fEncoding;
    private final int fMessageMaxBytes;
    private final BytesMessageEncoder fEncoder;
    private final String fTopic;
    private final Map<String, Object> portieMap;

    private AutoValue_KafkaSender(Encoding fEncoding, int fMessageMaxBytes, BytesMessageEncoder fEncoder, String fTopic, Map<String, Object> portieMap) {
        this.fEncoding = fEncoding;
        this.fMessageMaxBytes = fMessageMaxBytes;
        this.fEncoder = fEncoder;
        this.fTopic = fTopic;
        this.portieMap = portieMap;
    }

    public Encoding encoding() {
        return this.fEncoding;
    }

    public int messageMaxBytes() {
        return this.fMessageMaxBytes;
    }

    @Override
    BytesMessageEncoder encoder() {
        return this.fEncoder;
    }

    @Override
    String topic() {
        return this.fTopic;
    }

    @Override
    Map<String, Object> properties() {
        return this.portieMap;
    }

    public String toString() {
        return "KafkaSender{encoding=" + this.fEncoding + ", messageMaxBytes=" + this.fMessageMaxBytes + ", encoder=" + this.fEncoder + ", topic=" + this.fTopic + ", properties=" + this.portieMap + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KafkaSender) {
            KafkaSender that = (KafkaSender)((Object)o);
            return this.fEncoding.equals((Object)that.encoding()) && this.fMessageMaxBytes == that.messageMaxBytes() && this.fEncoder.equals((Object)that.encoder()) && this.fTopic.equals(that.topic()) && this.portieMap.equals(that.properties());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.fEncoding.hashCode();
        h *= 1000003;
        h ^= this.fMessageMaxBytes;
        h *= 1000003;
        h ^= this.fEncoder.hashCode();
        h *= 1000003;
        h ^= this.fTopic.hashCode();
        h *= 1000003;
        return h ^= this.portieMap.hashCode();
    }

    static final class Builder
    extends KafkaSender.Builder {
        private Encoding fEncoding;
        private Integer fMessageMaxBytes;
        private BytesMessageEncoder fEncoder;
        private String fTopic;
        private Map<String, Object> portieMap;

        Builder() {
        }

        Builder(KafkaSender source) {
            this.fEncoding = source.encoding();
            this.fMessageMaxBytes = source.messageMaxBytes();
            this.fEncoder = source.encoder();
            this.fTopic = source.topic();
            this.portieMap = source.properties();
        }

        @Override
        public KafkaSender.Builder encoding(Encoding encoding) {
            String paramEncoding = System.getProperty("trace.reporter.zipkin.kafka.encoding");
            this.fEncoding = Encoding.JSON.name().toLowerCase().equals(paramEncoding) ? Encoding.JSON : encoding;
            return this;
        }

        @Override
        public Encoding encoding() {
            if (this.fEncoding == null) {
                throw new IllegalStateException("Property \"encoding\" has not been set");
            }
            return this.fEncoding;
        }

        @Override
        public KafkaSender.Builder messageMaxBytes(int messageMaxBytes) {
            this.fMessageMaxBytes = messageMaxBytes;
            return this;
        }

        @Override
        public KafkaSender.Builder encoder(BytesMessageEncoder encoder) {
            this.fEncoder = encoder;
            return this;
        }

        @Override
        public KafkaSender.Builder topic(String topic) {
            this.fTopic = topic;
            return this;
        }

        @Override
        public KafkaSender.Builder properties(Map<String, Object> properties) {
            this.portieMap = properties;
            return this;
        }

        @Override
        public Map<String, Object> properties() {
            if (this.portieMap == null) {
                throw new IllegalStateException("Property \"properties\" has not been set");
            }
            return this.portieMap;
        }

        @Override
        public KafkaSender autoBuild() {
            String missing = "";
            if (this.fEncoding == null) {
                missing = missing + " encoding";
            }
            if (this.fMessageMaxBytes == null) {
                missing = missing + " messageMaxBytes";
            }
            if (this.fEncoder == null) {
                missing = missing + " encoder";
            }
            if (this.fTopic == null) {
                missing = missing + " topic";
            }
            if (this.portieMap == null) {
                missing = missing + " properties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KafkaSender(this.fEncoding, this.fMessageMaxBytes, this.fEncoder, this.fTopic, this.portieMap);
        }
    }
}

