/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.reporter.zipkin.kafka08;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.trace.reporter.zipkin.kafka08.AutoValue_KafkaSender;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import zipkin.Component;
import zipkin.internal.LazyCloseable;
import zipkin.internal.Util;
import zipkin.reporter.BytesMessageEncoder;
import zipkin.reporter.Callback;
import zipkin.reporter.Encoding;
import zipkin.reporter.Sender;

public abstract class KafkaSender
extends LazyCloseable<KafkaProducer<byte[], byte[]>>
implements Sender {
    private static final String USER = "trace.kafka.user";
    private static final String PD = "trace.kafka.password";
    private static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String DEFAULT_SECURITY_PROTOCOL = "SASL_PLAINTEXT";
    private static final String DEFAULT_SASL_MECHANISM = "PLAIN";
    private volatile boolean closeCalled;

    KafkaSender() {
    }

    public static KafkaSender create(String servers, String topic) {
        return KafkaSender.builder().bootstrapServers(servers).topic(topic).build();
    }

    public static Builder builder() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("key.serializer", ByteArraySerializer.class.getName());
        properties.put("value.serializer", ByteArraySerializer.class.getName());
        properties.put("acks", "0");
        properties.put("max.request.size", 0xA00000);
        KafkaSender.basicAuth(properties);
        return new AutoValue_KafkaSender.Builder().encoding(Encoding.THRIFT).properties(properties).messageMaxBytes(0xA00000);
    }

    private static void basicAuth(HashMap<String, Object> properties) {
        String user = System.getProperty(USER);
        String password = System.getProperty(PD);
        if (user != null && password != null) {
            String config = KafkaSender.getKafkaAuthConfig(user, password);
            properties.put(SASL_JAAS_CONFIG, config);
            properties.put(SASL_MECHANISM, DEFAULT_SASL_MECHANISM);
            properties.put(SECURITY_PROTOCOL, DEFAULT_SECURITY_PROTOCOL);
        }
    }

    private static String getKafkaAuthConfig(String userName, String password) {
        return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + userName + "\" password=\"" + password + "\";";
    }

    public Builder toBuilder() {
        return new AutoValue_KafkaSender.Builder(this);
    }

    abstract BytesMessageEncoder encoder();

    abstract String topic();

    abstract Map<String, Object> properties();

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public void sendSpans(List encodedSpans, Callback callback) {
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        try {
            byte[] message = this.encoder().encode(encodedSpans);
            ((KafkaProducer)this.get()).send(new ProducerRecord(this.topic(), (Object)message), (metadata, exception) -> {
                if (exception == null) {
                    callback.onComplete();
                } else {
                    callback.onError((Throwable)exception);
                }
            });
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
        catch (Error e) {
            callback.onError((Throwable)e);
            throw e;
        }
    }

    public Component.CheckResult check() {
        try {
            ((KafkaProducer)this.get()).partitionsFor(this.topic());
            return Component.CheckResult.OK;
        }
        catch (RuntimeException e) {
            return Component.CheckResult.failed((Exception)e);
        }
    }

    protected KafkaProducer<byte[], byte[]> compute() {
        return new KafkaProducer(this.properties());
    }

    public void close() throws IOException {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        super.close();
    }

    public static abstract class Builder {
        Builder() {
        }

        abstract Builder properties(Map<String, Object> var1);

        public abstract Builder topic(String var1);

        abstract Map<String, Object> properties();

        public final Builder bootstrapServers(String bootstrapServers) {
            this.properties().put("bootstrap.servers", Util.checkNotNull((Object)bootstrapServers, (String)"bootstrapServers"));
            return this;
        }

        public abstract Builder messageMaxBytes(int var1);

        public final Builder overrides(Map<String, String> overrides) {
            this.properties().putAll((Map)Util.checkNotNull(overrides, (String)"overrides"));
            return this;
        }

        public abstract Builder encoding(Encoding var1);

        abstract Encoding encoding();

        public final KafkaSender build() {
            return this.encoder(BytesMessageEncoder.forEncoding((Encoding)this.encoding())).autoBuild();
        }

        abstract Builder encoder(BytesMessageEncoder var1);

        public abstract KafkaSender autoBuild();
    }
}

