/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.sampler;

import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.Sampler;
import kd.bos.trace.sampler.AlwaysSampler;
import kd.bos.trace.sampler.PercentageBasedSampler;
import kd.bos.trace.sampler.SamplerProperties;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredSampler
implements Sampler {
    private static final String TYPE_KEY = "trace.sampler.type";
    private static final String PERCENT_KEY = "trace.sampler.percent";
    private static Logger logger = LoggerFactory.getLogger(ConfiguredSampler.class);
    private Sampler sampler;
    private SamplerProperties sampleProp = new SamplerProperties();
    private int currentPercent = -1;

    public ConfiguredSampler() {
        this.initSampler();
        this.initListener();
    }

    private void initListener() {
        ConfigurationUtil.observeChange((String)TYPE_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object p0, Object p1) {
                ConfiguredSampler.this.initSampler();
            }
        });
        ConfigurationUtil.observeChange((String)PERCENT_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object p0, Object p1) {
                ConfiguredSampler.this.percentChanged((String)p1);
            }
        });
    }

    protected void percentChanged(String str) {
        if (str == null) {
            return;
        }
        if (this.sampler instanceof PercentageBasedSampler) {
            try {
                if (this.currentPercent != Integer.parseInt(str.trim())) {
                    this.initPercentSampler();
                }
            }
            catch (Exception e) {
                logger.warn("ConfiguredSampler.percentChanged error:" + e.getMessage());
            }
        }
    }

    private void initSampler() {
        String type = SystemProperties.getWithEnv((String)TYPE_KEY);
        if ("percent".equals(type)) {
            this.initPercentSampler();
        } else {
            this.sampler = new AlwaysSampler();
        }
    }

    private void initPercentSampler() {
        int currentPercent = ConfigurationUtil.getInteger((String)PERCENT_KEY, (Integer)100, (boolean)true);
        if (currentPercent > 100) {
            currentPercent = 100;
        } else if (currentPercent < 0) {
            currentPercent = 0;
        }
        this.sampleProp.setPercentage(1.0f * (float)currentPercent / 100.0f);
        this.sampler = new PercentageBasedSampler(this.sampleProp);
    }

    @Override
    public boolean isSampled(InnerSpan span) {
        return this.sampler.isSampled(span);
    }
}

