/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.tracer;

import kd.bos.trace.core.MemSpan;
import kd.bos.trace.tracer.TracerImpl;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MemSpanTrace
implements AutoCloseable {
    private MemSpan mspan;
    private MemSpanTrace parent = tl.get();
    private static ThreadLocal<MemSpanTrace> tl = new ThreadLocal();

    public static MemSpanTrace create(String type, String name) {
        return new MemSpanTrace(type, name);
    }

    private MemSpanTrace(String type, String name) {
        this.mspan = new MemSpan(type, name, null);
        tl.set(this);
        TracerImpl.getInstrumentMap().put(this.mspan, System.currentTimeMillis());
    }

    public static MemSpanTrace getCurrent() {
        return tl.get();
    }

    public MemSpanTrace addTag(String key, String value) {
        this.mspan.tagInMem(key, value);
        return this;
    }

    @Override
    public void close() {
        TracerImpl.getInstrumentMap().remove(this.mspan);
        tl.set(this.parent);
    }
}

