/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.tracer;

import java.util.Map;
import kd.bos.context.OperationContext;
import kd.bos.instance.Instance;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerSpanReporter;
import kd.bos.trace.reporter.apicall.APICallReporterProvider;
import kd.bos.trace.reporter.topology.TopologyReporterProvider;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.tracer.TracerImpl;
import kd.bos.util.LRUCacheMap;

public class TraceSpanImpl
implements TraceSpan {
    private static final InnerSpanReporter topologyReporter = TopologyReporterProvider.getInstance();
    private static final InnerSpanReporter apiCallReporter = APICallReporterProvider.getInstance();
    private static ThreadLocal<TraceSpanImpl> tl = new ThreadLocal();
    private final long startTimestap;
    private TraceSpanImpl parent = null;
    private InnerSpan span;
    private InnerSpan governSpan;
    private String type;
    private String name;
    private LRUCacheMap<String, LRUCacheMap<String, Integer>> treeCostMap = new LRUCacheMap(8);

    private TraceSpanImpl() {
        this.parent = tl.get();
        tl.set(this);
        this.startTimestap = System.currentTimeMillis();
    }

    public TraceSpanImpl(String type, String name, boolean isCrossNode) {
        this();
        this.type = type;
        this.name = name;
        this.span = TracerImpl.getInnerTracer().createSpan(name, isCrossNode);
        this.span.tag("service", type);
        Object rcInfo = ThreadTruck.get((Object)"rcinfo");
        OperationContext operationContext = OperationContext.get();
        if (rcInfo instanceof Map) {
            Map rcInfoMap = (Map)rcInfo;
            this.span.tag("userName", (String)rcInfoMap.get("userName"));
        }
        if (operationContext != null) {
            this.span.tag("appId", operationContext.getAppId());
        }
    }

    public static TraceSpanImpl createEmpty(String type, String name) {
        TraceSpanImpl span = new TraceSpanImpl();
        span.type = type;
        span.name = name;
        return span;
    }

    public static TraceSpanImpl getCurrent() {
        return tl.get();
    }

    @Override
    public InnerSpan getInnerSpan() {
        return this.span;
    }

    public InnerSpan getGovernSpan() {
        return this.governSpan;
    }

    public void setGovernSpan(InnerSpan span) {
        this.governSpan = span;
    }

    @Override
    public void close() {
        if (this.span != null) {
            if (this.span.getParents() == null || this.span.getParents().isEmpty()) {
                this.span.tag("clusterName", Instance.getClusterName());
            }
            if (Boolean.getBoolean("trace.stack.enable") && this.span.getCost() > Integer.parseInt(System.getProperty("trace.stack.timefilter", "1000"))) {
                this.addTag("stacktrace", this.getStackTrace(), true);
            }
            TracerImpl.getInnerTracer().close(this.span);
        } else if (this.governSpan != null) {
            topologyReporter.report(this.governSpan);
            apiCallReporter.report(this.governSpan);
        }
        if (this.parent != null) {
            LRUCacheMap nameCostMap = (LRUCacheMap)this.parent.treeCostMap.computeIfAbsent((Object)this.type, n -> new LRUCacheMap(8));
            nameCostMap.put((Object)this.name, (Object)this.getCost());
        }
        boolean hasSameTypeInParents = false;
        TraceSpanImpl _p = this.parent;
        while (_p != null) {
            if (this.type.equals(_p.type)) {
                hasSameTypeInParents = true;
                break;
            }
            _p = _p.parent;
        }
        tl.set(this.parent);
        if (!hasSameTypeInParents) {
            TraceStatistics.statistic(this.type, System.currentTimeMillis() - this.startTimestap);
        }
    }

    public LRUCacheMap<String, LRUCacheMap<String, Integer>> getTreeCostMap() {
        return this.treeCostMap;
    }

    private String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        Exception e = new Exception();
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        int size = stackTraceElements.length > 50 ? 50 : stackTraceElements.length;
        for (int i = 2; i < size; ++i) {
            sb.append("\tat ").append(stackTraceElements[i]);
        }
        return sb.toString();
    }

    @Override
    public TraceSpan addTag(String key, String value, boolean force) {
        if (this.span != null && (force || TraceConfig.isTagEnable(this.type, key))) {
            this.span.tag(key, value);
        }
        return this;
    }

    @Override
    public TraceSpan addCustomStatistics(String key, long value) {
        TraceStatistics.statisticCustomItem(this.type, key, value);
        return this;
    }

    @Override
    public TraceSpan logEvent(String event) {
        if (this.span != null && TraceConfig.isEventEnable(this.type, event)) {
            this.span.logEvent(event);
        }
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCost() {
        return this.span == null ? (int)(System.currentTimeMillis() - this.startTimestap) : this.span.getCost();
    }

    @Override
    public void methodInstrumentForThreaddump() {
    }

    @Override
    public long getStartTime() {
        return this.startTimestap;
    }
}

