/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.trace.tracer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.thread.ThreadEndClear;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.core.InnerFactory;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.MemSpan;
import kd.bos.trace.tracer.TraceSpanImpl;
import kd.bos.util.StringUtils;

public class TracerImpl {
    private static InnerTracer innerTracer = TracerImpl.createInnerTracer();
    private static Map<Long, Map<MemSpan, Long>> methodInstrument = new ConcurrentHashMap<Long, Map<MemSpan, Long>>();
    private static ThreadLocal<AutoCloseable> l = new ThreadLocal<AutoCloseable>(){

        @Override
        protected AutoCloseable initialValue() {
            Long t = Thread.currentThread().getId();
            Map instrumentMap = (Map)methodInstrument.get(t);
            if (null != instrumentMap) {
                instrumentMap.clear();
            }
            return () -> methodInstrument.remove(t);
        }
    };

    private static InnerTracer createInnerTracer() {
        return InnerFactory.getTracer();
    }

    static InnerTracer getInnerTracer() {
        return innerTracer;
    }

    public static TraceSpan getCurrent() {
        return TraceSpanImpl.getCurrent();
    }

    public static void close() {
        TraceSpanImpl span = TraceSpanImpl.getCurrent();
        if (span != null) {
            span.close();
        }
    }

    public static boolean isTracing() {
        return innerTracer.isTracing();
    }

    public static TraceSpanImpl create(String type, String name, boolean isCrossNode) {
        if (TraceConfig.isTraceEnable() && (isCrossNode || TraceConfig.isTypeEnable(type) && TraceConfig.isSpanEnable(type, name))) {
            if (TracerImpl.isTracing() || TracerImpl.isExport(type)) {
                return new TraceSpanImpl(type, name, isCrossNode);
            }
            return TraceSpanImpl.createEmpty(type, name);
        }
        return TraceSpanImpl.createEmpty(type, name);
    }

    private static boolean isExport(String type) {
        String property = System.getProperty("gov.trace.reporter.types");
        if (StringUtils.isNotEmpty((String)property)) {
            String[] split;
            for (String name : split = property.split(",")) {
                if (!name.equals(type)) continue;
                return true;
            }
        }
        return "WebRequest".equals(type) || "RpcRequest".equals(type);
    }

    public static void addTag(String key, String value) {
        TracerImpl.addTag(key, value, false);
    }

    public static void addTag(String key, String value, boolean force) {
        TraceSpanImpl span = TraceSpanImpl.getCurrent();
        if (span != null) {
            span.addTag(key, value, force);
        }
    }

    public static void logEvent(String event) {
        TraceSpanImpl span = TraceSpanImpl.getCurrent();
        if (span != null) {
            span.logEvent(event);
        }
    }

    public static Map<MemSpan, Long> getInstrumentMap() {
        Long t = Thread.currentThread().getId();
        Map instrumentMap = methodInstrument.computeIfAbsent(t, key -> new HashMap(2));
        l.get();
        if (instrumentMap.size() > 3) {
            instrumentMap.clear();
        }
        return instrumentMap;
    }

    public static Map<MemSpan, Long> getInstrumentMap(Thread t) {
        return methodInstrument.get(t.getId());
    }

    static {
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            methodInstrument.forEach((k, v) -> {
                if (!threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> methodInstrument.remove(k));
        });
    }
}

